/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.ui.TextField;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TextFieldConstructorTest {
    @Test
    public void initiallyEmpty() {
        TextField textField = new TextField();
        Assert.assertTrue((boolean)textField.isEmpty());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        TextField textField = new TextField(null, "foobar");
        Assert.assertFalse((boolean)textField.isEmpty());
        textField.clear();
        Assert.assertTrue((boolean)textField.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        TextField textField = new TextField(valueChangeListener);
        textField.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        TextField textField = new TextField("Caption", "Initial value", valueChangeListener);
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        textField.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

