/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.provider.DataProvider;
import com.vaadin.event.selection.SingleSelectionListener;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.data.selection.SelectionServerRpc;
import com.vaadin.ui.RadioButtonGroup;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RadioButtonGroupTest {
    private RadioButtonGroup<String> radioButtonGroup;

    @Before
    public void setUp() {
        this.radioButtonGroup = new RadioButtonGroup();
        this.radioButtonGroup.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new String[]{"Third", "Second", "First"}));
    }

    @Test
    public void apiSelectionChange_notUserOriginated() {
        AtomicInteger listenerCount = new AtomicInteger(0);
        this.radioButtonGroup.addSelectionListener((SingleSelectionListener & Serializable)event -> {
            listenerCount.incrementAndGet();
            Assert.assertFalse((boolean)event.isUserOriginated());
        });
        this.radioButtonGroup.setValue((Object)"First");
        this.radioButtonGroup.setValue((Object)"Second");
        this.radioButtonGroup.setValue(null);
        this.radioButtonGroup.setValue(null);
        Assert.assertEquals((long)3L, (long)listenerCount.get());
    }

    @Test
    public void rpcSelectionChange_userOriginated() {
        AtomicInteger listenerCount = new AtomicInteger(0);
        this.radioButtonGroup.addSelectionListener((SingleSelectionListener & Serializable)event -> {
            listenerCount.incrementAndGet();
            Assert.assertTrue((boolean)event.isUserOriginated());
        });
        SelectionServerRpc rpc = (SelectionServerRpc)ServerRpcManager.getRpcProxy(this.radioButtonGroup, SelectionServerRpc.class);
        rpc.select(this.getItemKey("First"));
        rpc.select(this.getItemKey("Second"));
        rpc.deselect(this.getItemKey("Second"));
        Assert.assertEquals((long)3L, (long)listenerCount.get());
    }

    private String getItemKey(String dataObject) {
        return this.radioButtonGroup.getDataCommunicator().getKeyMapper().key((Object)dataObject);
    }
}

