/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import org.junit.Assert;
import org.junit.Test;

public class GridLayoutExpandRatioTest {
    private GridLayout gridLayout;

    @Test
    public void testColExpandRatioIsForgotten() {
        this.gridLayout = new GridLayout(4, 1);
        this.gridLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.gridLayout.setSizeFull();
        this.gridLayout.setSpacing(true);
        this.addComponents(true);
        this.gridLayout.setColumnExpandRatio(1, 1.0f);
        this.gridLayout.setColumnExpandRatio(3, 1.0f);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(0) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(1) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(2) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(3) == 1.0f ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitColRatios.contains(0));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitColRatios.contains(1));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitColRatios.contains(2));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitColRatios.contains(3));
        this.gridLayout.removeAllComponents();
        this.gridLayout.setColumns(3);
        this.addComponents(false);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(0) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(1) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(2) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getColumnExpandRatio(3) == 0.0f ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitColRatios.contains(0));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitColRatios.contains(1));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitColRatios.contains(2));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitColRatios.contains(3));
    }

    @Test
    public void testRowExpandRatioIsForgotten() {
        this.gridLayout = new GridLayout(1, 4);
        this.gridLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.gridLayout.setSizeFull();
        this.gridLayout.setSpacing(true);
        this.addComponents(true);
        this.gridLayout.setRowExpandRatio(1, 1.0f);
        this.gridLayout.setRowExpandRatio(3, 1.0f);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(0) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(1) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(2) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(3) == 1.0f ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitRowRatios.contains(0));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitRowRatios.contains(1));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitRowRatios.contains(2));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitRowRatios.contains(3));
        this.gridLayout.removeAllComponents();
        this.gridLayout.setRows(3);
        this.addComponents(false);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(0) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(1) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(2) == 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((this.gridLayout.getRowExpandRatio(3) == 0.0f ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitRowRatios.contains(0));
        Assert.assertTrue((boolean)this.gridLayout.getState().explicitRowRatios.contains(1));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitRowRatios.contains(2));
        Assert.assertFalse((boolean)this.gridLayout.getState().explicitRowRatios.contains(3));
    }

    private void addComponents(boolean includeLastOne) {
        this.gridLayout.addComponent((Component)this.label("{1}"));
        this.gridLayout.addComponent((Component)this.label("{2}"));
        this.gridLayout.addComponent((Component)this.label("{3}"));
        if (includeLastOne) {
            this.gridLayout.addComponent((Component)this.label("{4}"));
        }
    }

    private Label label(String content) {
        Label label = new Label(content);
        label.setSizeUndefined();
        return label;
    }
}

