/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.ui.checkbox.CheckBoxServerRpc;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentTest;
import com.vaadin.ui.HasStyleNames;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CheckBoxTest {
    @Test
    public void initiallyFalse() {
        CheckBox cb = new CheckBox();
        Assert.assertFalse((boolean)cb.getValue());
    }

    @Test
    public void testSetValue() {
        CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(true));
        Assert.assertTrue((boolean)cb.getValue());
        cb.setValue(Boolean.valueOf(false));
        Assert.assertFalse((boolean)cb.getValue());
    }

    @Test
    public void setValueChangeFromClientIsUserOriginated() {
        MockUI ui = new MockUI();
        CheckBox cb = new CheckBox();
        ui.setContent((Component)cb);
        AtomicBoolean userOriginated = new AtomicBoolean(false);
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> userOriginated.set(event.isUserOriginated()));
        ComponentTest.syncToClient((AbstractComponent)cb);
        ((CheckBoxServerRpc)ServerRpcManager.getRpcProxy((ClientConnector)cb, CheckBoxServerRpc.class)).setChecked(true, new MouseEventDetails());
        Assert.assertTrue((boolean)userOriginated.get());
        userOriginated.set(false);
        ComponentTest.syncToClient((AbstractComponent)cb);
        ((CheckBoxServerRpc)ServerRpcManager.getRpcProxy((ClientConnector)cb, CheckBoxServerRpc.class)).setChecked(false, new MouseEventDetails());
        Assert.assertTrue((boolean)userOriginated.get());
    }

    @Test
    public void setValueChangeFromServerIsNotUserOriginated() {
        MockUI ui = new MockUI();
        CheckBox cb = new CheckBox();
        ui.setContent((Component)cb);
        AtomicBoolean userOriginated = new AtomicBoolean(true);
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> userOriginated.set(event.isUserOriginated()));
        cb.setValue(Boolean.valueOf(true));
        Assert.assertFalse((boolean)userOriginated.get());
        userOriginated.set(true);
        cb.setValue(Boolean.valueOf(false));
        Assert.assertFalse((boolean)userOriginated.get());
    }

    @Test(expected=NullPointerException.class)
    public void setValue_nullValue_throwsNPE() {
        CheckBox cb = new CheckBox();
        cb.setValue(null);
    }

    @Test
    public void getComboBoxInput() {
        CheckBox cb = new CheckBox();
        Assert.assertNotNull((String)"getInputElement should always return a element", (Object)cb.getInputElement());
        this.assertHasStyleNames((HasStyleNames)cb.getInputElement());
    }

    @Test
    public void getCheckBoxLabel() {
        CheckBox cb = new CheckBox();
        Assert.assertNotNull((String)"getLabelElement should always return a element", (Object)cb.getLabelElement());
        this.assertHasStyleNames((HasStyleNames)cb.getLabelElement());
    }

    @Test
    @Ignore(value="Component#setStyleName(null, false) should not throw a NPE")
    public void setStyleName_null_false_throws_NPE() {
        CheckBox cb = new CheckBox();
        cb.getLabelElement().addStyleName("first");
        cb.getLabelElement().setStyleName(null, false);
        Assert.assertEquals((String)"Removing a null style should be ignored", (Object)"first", (Object)cb.getLabelElement().getStyleName());
    }

    private void assertHasStyleNames(HasStyleNames hasStyleNames) {
        Assert.assertEquals((String)"Given element should not have a default style name", (Object)"", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName("first");
        Assert.assertEquals((Object)"first", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName("first");
        Assert.assertEquals((String)"Adding two times the same style should be ignored", (Object)"first", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName(null);
        Assert.assertEquals((String)"Adding null as style should be ignored", (Object)"first", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName("");
        Assert.assertEquals((String)"Adding an empty string as style should be ignored", (Object)"first", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName("second");
        Assert.assertEquals((Object)"first second", (Object)hasStyleNames.getStyleName());
        hasStyleNames.removeStyleName("second");
        Assert.assertEquals((Object)"first", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleName("second third fourth");
        Assert.assertEquals((Object)"first second third fourth", (Object)hasStyleNames.getStyleName());
        hasStyleNames.removeStyleName("third fourth");
        Assert.assertEquals((Object)"first second", (Object)hasStyleNames.getStyleName());
        hasStyleNames.addStyleNames(new String[]{"third", "fourth"});
        Assert.assertEquals((Object)"first second third fourth", (Object)hasStyleNames.getStyleName());
        hasStyleNames.removeStyleNames(new String[]{"second", "fourth"});
        Assert.assertEquals((Object)"first third", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName(null);
        Assert.assertEquals((String)"Setting null as style should reset them", (Object)"", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("set-style");
        Assert.assertEquals((Object)"set-style", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("");
        Assert.assertEquals((String)"Setting an empty string as style should reset them", (Object)"", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("set-style multiple values");
        Assert.assertEquals((Object)"set-style multiple values", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("set-style", false);
        Assert.assertEquals((Object)"multiple values", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("", false);
        Assert.assertEquals((String)"Removing an empty style should be ignored", (Object)"multiple values", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("", true);
        Assert.assertEquals((String)"Adding an empty style should be ignored", (Object)"multiple values", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName(null, true);
        Assert.assertEquals((String)"Adding a null style should be ignored", (Object)"multiple values", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("multiple values", false);
        Assert.assertEquals((String)"Removing all set style names should result in an empty style name", (Object)"", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("set-style", true);
        Assert.assertEquals((Object)"set-style", (Object)hasStyleNames.getStyleName());
        hasStyleNames.setStyleName("multiple values", true);
        Assert.assertEquals((Object)"set-style multiple values", (Object)hasStyleNames.getStyleName());
    }
}

