/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.event.selection.MultiSelectionEvent;
import com.vaadin.event.selection.MultiSelectionListener;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.Registration;
import com.vaadin.shared.data.selection.MultiSelectServerRpc;
import com.vaadin.ui.AbstractMultiSelect;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.ListSelect;
import com.vaadin.ui.TwinColSelect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AbstractMultiSelectTest<S extends AbstractMultiSelect<String>> {
    @Parameterized.Parameter
    public S selectToTest;
    private MultiSelectServerRpc rpc;
    private Registration registration;
    private List<Set<String>> values;
    private List<Set<String>> oldValues;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<?> multiSelects() {
        return Arrays.asList(new CheckBoxGroup(), new TwinColSelect(), new ListSelect());
    }

    @Before
    public void setUp() {
        this.selectToTest.deselectAll();
        this.selectToTest.setItems((Object[])new String[]{"3", "2", "1", "5", "8", "7", "4", "6"});
        this.rpc = (MultiSelectServerRpc)ServerRpcManager.getRpcProxy(this.selectToTest, MultiSelectServerRpc.class);
        this.values = new ArrayList<Set<String>>();
        this.oldValues = new ArrayList<Set<String>>();
        this.selectToTest.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.values.add((Set)event.getValue()));
        this.selectToTest.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.oldValues.add((Set)event.getOldValue()));
    }

    @After
    public void tearDown() {
        if (this.registration != null) {
            this.registration.remove();
            this.registration = null;
        }
    }

    @Test
    public void stableSelectionOrder() {
        this.selectToTest.select((Object[])new String[]{"1"});
        this.selectToTest.select((Object[])new String[]{"2"});
        this.selectToTest.select((Object[])new String[]{"3"});
        this.assertSelectionOrder("1", "2", "3");
        this.selectToTest.deselect((Object[])new String[]{"1"});
        this.assertSelectionOrder("2", "3");
        this.selectToTest.select((Object[])new String[]{"1"});
        this.assertSelectionOrder("2", "3", "1");
        this.selectToTest.select((Object[])new String[]{"7", "8", "4"});
        this.assertSelectionOrder("2", "3", "1", "7", "8", "4");
        this.selectToTest.deselect((Object[])new String[]{"2", "1", "4", "5"});
        this.assertSelectionOrder("3", "7", "8");
        this.selectToTest.updateSelection(new LinkedHashSet<String>(Arrays.asList("5", "2")), new LinkedHashSet<String>(Arrays.asList("3", "8")));
        this.assertSelectionOrder("7", "5", "2");
        this.verifyValueChangeEvents();
    }

    @Test
    public void apiSelectionChange_notUserOriginated() {
        AtomicInteger listenerCount = new AtomicInteger(0);
        listenerCount.set(0);
        this.registration = this.selectToTest.addSelectionListener((MultiSelectionListener & Serializable)event -> {
            listenerCount.incrementAndGet();
            Assert.assertFalse((boolean)event.isUserOriginated());
        });
        this.selectToTest.select((Object[])new String[]{"1"});
        this.selectToTest.select((Object[])new String[]{"2"});
        this.selectToTest.deselect((Object[])new String[]{"2"});
        this.selectToTest.deselectAll();
        this.selectToTest.select((Object[])new String[]{"2", "3", "4"});
        this.selectToTest.deselect((Object[])new String[]{"1", "4"});
        Assert.assertEquals((long)6L, (long)listenerCount.get());
        this.selectToTest.select((Object[])new String[]{"2", "3", "4"});
        Assert.assertEquals((long)7L, (long)listenerCount.get());
        this.selectToTest.select((Object[])new String[]{"2", "3", "4"});
        Assert.assertEquals((long)7L, (long)listenerCount.get());
        this.selectToTest.select((Object[])new String[]{"1", "4"});
        Assert.assertEquals((long)8L, (long)listenerCount.get());
        this.selectToTest.select((Object[])new String[]{"1", "4"});
        Assert.assertEquals((long)8L, (long)listenerCount.get());
        this.verifyValueChangeEvents();
    }

    @Test
    public void rpcSelectionChange_userOriginated() {
        AtomicInteger listenerCount = new AtomicInteger(0);
        this.registration = this.selectToTest.addSelectionListener((MultiSelectionListener & Serializable)event -> {
            listenerCount.incrementAndGet();
            Assert.assertTrue((boolean)event.isUserOriginated());
        });
        this.rpcSelect("1");
        this.assertSelectionOrder("1");
        this.rpcSelect("2");
        this.assertSelectionOrder("1", "2");
        this.rpcDeselectItems("2");
        this.assertSelectionOrder("1");
        this.rpcSelect("3", "6");
        this.assertSelectionOrder("1", "3", "6");
        this.rpcDeselectItems("1", "3");
        this.assertSelectionOrder("6");
        Assert.assertEquals((long)5L, (long)listenerCount.get());
        this.rpcSelect("2", "3", "4");
        Assert.assertEquals((long)6L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3", "4");
        this.rpcSelect("2", "3", "4");
        Assert.assertEquals((long)6L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3", "4");
        this.rpcDeselectItems("1", "4");
        Assert.assertEquals((long)7L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3");
        this.rpcDeselectItems("1", "4");
        Assert.assertEquals((long)7L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3");
        this.rpcUpdateSelection(new String[]{"3"}, new String[]{"1", "4"});
        Assert.assertEquals((long)7L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3");
        this.rpcUpdateSelection(new String[]{"4", "2"}, new String[]{"1", "8"});
        Assert.assertEquals((long)8L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "2", "3", "4");
        this.rpcUpdateSelection(new String[]{"4", "3"}, new String[]{"1", "2"});
        Assert.assertEquals((long)9L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "3", "4");
        this.rpcUpdateSelection(new String[]{"2"}, new String[]{"2"});
        Assert.assertEquals((long)9L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "3", "4");
        this.rpcUpdateSelection(new String[]{"2"}, new String[]{"2", "3"});
        Assert.assertEquals((long)10L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "4");
        this.rpcUpdateSelection(new String[]{"6", "8"}, new String[]{"6"});
        Assert.assertEquals((long)11L, (long)listenerCount.get());
        this.assertSelectionOrder("6", "4", "8");
        this.verifyValueChangeEvents();
    }

    @Test
    public void getValue() {
        this.selectToTest.select((Object[])new String[]{"1"});
        Assert.assertEquals(Collections.singleton("1"), (Object)this.selectToTest.getValue());
        this.selectToTest.deselectAll();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("1");
        set.add("5");
        this.selectToTest.select((Object[])set.toArray(new String[2]));
        Assert.assertEquals(set, (Object)this.selectToTest.getValue());
        set.add("3");
        this.selectToTest.select((Object[])new String[]{"3"});
        Assert.assertEquals(set, (Object)this.selectToTest.getValue());
        this.verifyValueChangeEvents();
    }

    @Test
    public void getValue_isDelegatedTo_getSelectedItems() {
        final Set set = (Set)Mockito.mock(Set.class);
        AbstractMultiSelect<String> select = new AbstractMultiSelect<String>(){

            public Set<String> getSelectedItems() {
                return set;
            }

            public void setItems(Collection<String> items) {
                throw new UnsupportedOperationException("Not implemented for this test");
            }

            public DataProvider<String, ?> getDataProvider() {
                return null;
            }
        };
        Assert.assertSame((Object)set, (Object)select.getValue());
        this.verifyValueChangeEvents();
    }

    @Test
    public void setValue() {
        this.selectToTest.setValue(Collections.singleton("1"));
        Assert.assertEquals(Collections.singleton("1"), (Object)this.selectToTest.getSelectedItems());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("4");
        set.add("3");
        this.selectToTest.setValue(set);
        Assert.assertEquals(set, (Object)this.selectToTest.getSelectedItems());
        this.verifyValueChangeEvents();
    }

    @Test
    public void setValue_isDelegatedToDeselectAndUpdateSelection() {
        AbstractMultiSelect select = (AbstractMultiSelect)Mockito.mock(AbstractMultiSelect.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("foo1");
        set.add("foo");
        LinkedHashSet<String> selected = new LinkedHashSet<String>();
        selected.add("bar1");
        selected.add("bar");
        selected.add("bar2");
        Mockito.when((Object)select.getSelectedItems()).thenReturn(selected);
        ((AbstractMultiSelect)Mockito.doCallRealMethod().when((Object)select)).setValue(Mockito.anySet());
        select.setValue(set);
        ((AbstractMultiSelect)Mockito.verify((Object)select)).updateSelection(set, selected);
    }

    @Test
    public void addValueChangeListener() {
        final AtomicReference selectionListener = new AtomicReference();
        final Registration registration = (Registration)Mockito.mock(Registration.class);
        final HashSet<String> set = new HashSet<String>();
        set.add("foo");
        set.add("bar");
        AbstractMultiSelect<String> select = new AbstractMultiSelect<String>(){

            public Registration addSelectionListener(MultiSelectionListener<String> listener) {
                selectionListener.set(listener);
                return registration;
            }

            public Set<String> getValue() {
                return set;
            }

            public void setItems(Collection<String> items) {
                throw new UnsupportedOperationException("Not implemented for this test");
            }

            public DataProvider<String, ?> getDataProvider() {
                return null;
            }
        };
        AtomicReference event = new AtomicReference();
        Registration actualRegistration = select.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> {
            Assert.assertNull(event.get());
            event.set(evt);
        });
        Assert.assertSame((Object)registration, (Object)actualRegistration);
        ((MultiSelectionListener)selectionListener.get()).selectionChange(new MultiSelectionEvent((AbstractMultiSelect)select, (Set)Mockito.mock(Set.class), true));
        Assert.assertEquals((Object)select, (Object)((HasValue.ValueChangeEvent)event.get()).getComponent());
        Assert.assertEquals(set, (Object)((HasValue.ValueChangeEvent)event.get()).getValue());
        Assert.assertTrue((boolean)((HasValue.ValueChangeEvent)event.get()).isUserOriginated());
    }

    private void rpcSelect(String ... keysToSelect) {
        this.rpcUpdateSelection(keysToSelect, new String[0]);
    }

    private void rpcDeselectItems(String ... keysToDeselect) {
        this.rpcUpdateSelection(new String[0], keysToDeselect);
    }

    private void rpcUpdateSelection(String[] added, String[] removed) {
        this.rpc.updateSelection(new LinkedHashSet(Stream.of(added).map(this::getItemKey).collect(Collectors.toList())), new LinkedHashSet(Stream.of(removed).map(this::getItemKey).collect(Collectors.toList())));
    }

    private String getItemKey(String dataObject) {
        return this.selectToTest.getDataCommunicator().getKeyMapper().key((Object)dataObject);
    }

    private void assertSelectionOrder(String ... selectionOrder) {
        Assert.assertEquals(Arrays.asList(selectionOrder), new ArrayList(this.selectToTest.getSelectedItems()));
    }

    private void verifyValueChangeEvents() {
        if (!this.oldValues.isEmpty()) {
            Assert.assertTrue((boolean)this.oldValues.get(0).isEmpty());
            Assert.assertEquals((long)this.values.size(), (long)this.oldValues.size());
            for (int i = 0; i < this.oldValues.size() - 1; ++i) {
                Assert.assertEquals(this.values.get(i), this.oldValues.get(i + 1));
            }
        }
    }
}

