/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.AbstractField;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractFieldTest
extends EasyMockSupport {
    TextField field;
    HasValue.ValueChangeListener<String> l;
    Capture<HasValue.ValueChangeEvent<String>> capture;

    @Before
    public void setUp() {
        this.field = new TextField();
        this.l = this.mockListener();
        this.capture = new Capture();
    }

    @Test
    public void readOnlyFieldAcceptsValueChangeFromServer() {
        this.field.setReadOnly(true);
        this.field.setValue("foo");
        Assert.assertEquals((Object)"foo", (Object)this.field.getValue());
    }

    @Test
    public void readOnlyFieldIgnoresValueChangeFromClient() {
        this.field.setReadOnly(true);
        this.field.setValue("bar", true);
        Assert.assertEquals((Object)"", (Object)this.field.getValue());
    }

    @Test
    public void valueChangeListenerInvoked() {
        this.l.valueChange((HasValue.ValueChangeEvent)EasyMock.capture(this.capture));
        this.replayAll();
        this.field.setValue("foo");
        this.field.addValueChangeListener(this.l);
        this.field.setValue("bar");
        this.assertEventEquals((HasValue.ValueChangeEvent<String>)((HasValue.ValueChangeEvent)this.capture.getValue()), "bar", (ClientConnector)this.field, false);
        this.verifyAll();
    }

    @Test
    public void valueChangeListenerInvokedFromClient() {
        this.l.valueChange((HasValue.ValueChangeEvent)EasyMock.capture(this.capture));
        this.replayAll();
        this.field.setValue("foo");
        this.field.addValueChangeListener(this.l);
        this.field.setValue("bar", true);
        this.assertEventEquals((HasValue.ValueChangeEvent<String>)((HasValue.ValueChangeEvent)this.capture.getValue()), "bar", (ClientConnector)this.field, true);
        this.verifyAll();
    }

    @Test
    public void valueChangeListenerNotInvokedIfValueUnchanged() {
        this.replayAll();
        this.field.setValue("foo");
        this.field.addValueChangeListener(this.l);
        this.field.setValue("foo");
        this.verifyAll();
    }

    @Test
    public void valueChangeListenerNotInvokedAfterRemove() {
        this.replayAll();
        this.field.addValueChangeListener(this.l).remove();
        this.field.setValue("foo");
        this.verifyAll();
    }

    private HasValue.ValueChangeListener<String> mockListener() {
        return (HasValue.ValueChangeListener)this.createStrictMock(HasValue.ValueChangeListener.class);
    }

    private void assertEventEquals(HasValue.ValueChangeEvent<String> e, String value, ClientConnector source, boolean userOriginated) {
        Assert.assertEquals((String)"event value", (Object)value, (Object)e.getValue());
        Assert.assertSame((String)"event source", (Object)source, (Object)e.getSource());
        Assert.assertSame((String)"event source connector", (Object)source, (Object)e.getSource());
        Assert.assertEquals((String)"event from user", (Object)userOriginated, (Object)e.isUserOriginated());
    }

    @Test
    public void identityField_realChange() {
        IdentityTextField identityField = new IdentityTextField();
        identityField.addValueChangeListener(this.l);
        this.l.valueChange((HasValue.ValueChangeEvent)EasyMock.capture(this.capture));
        this.replayAll();
        identityField.setValue("value");
        this.verifyAll();
    }

    @Test
    public void identityField_onlyIdentityChange() {
        IdentityTextField identityField = new IdentityTextField();
        identityField.setValue("value");
        identityField.addValueChangeListener(this.l);
        this.l.valueChange((HasValue.ValueChangeEvent)EasyMock.capture(this.capture));
        this.replayAll();
        String sameValueDifferentIdentity = new String("value");
        identityField.setValue(sameValueDifferentIdentity);
        this.verifyAll();
    }

    @Test
    public void identityField_noChange() {
        IdentityTextField identityField = new IdentityTextField();
        identityField.setValue("value");
        identityField.addValueChangeListener(this.l);
        this.replayAll();
        identityField.setValue(identityField.getValue());
        this.verifyAll();
    }

    class TextField
    extends AbstractField<String> {
        String value = "";

        TextField() {
        }

        public String getValue() {
            return this.value;
        }

        protected void doSetValue(String value) {
            this.value = value;
        }
    }

    private final class IdentityTextField
    extends TextField {
        private IdentityTextField() {
        }

        protected boolean isDifferentValue(String newValue) {
            return newValue != this.getValue();
        }
    }
}

