/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.components;

import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComponentAttachDetachListenerTest {
    private AbstractOrderedLayout olayout;
    private GridLayout gridlayout;
    private AbsoluteLayout absolutelayout;
    private CssLayout csslayout;
    private CustomLayout customlayout;
    private int attachCounter = 0;
    private Component attachedComponent = null;
    private HasComponents attachTarget = null;
    private boolean foundInContainer = false;
    private int detachCounter = 0;
    private Component detachedComponent = null;
    private HasComponents detachedTarget = null;
    private int indexOfComponent = -1;
    private GridLayout.Area componentArea = null;
    private AbsoluteLayout.ComponentPosition componentPosition = null;

    private void resetVariables() {
        this.attachCounter = 0;
        this.attachedComponent = null;
        this.attachTarget = null;
        this.foundInContainer = false;
        this.detachCounter = 0;
        this.detachedComponent = null;
        this.detachedTarget = null;
        this.indexOfComponent = -1;
        this.componentArea = null;
        this.componentPosition = null;
    }

    @Before
    public void setUp() {
        this.olayout = new HorizontalLayout();
        this.olayout.addComponentAttachListener((HasComponents.ComponentAttachListener)new MyAttachListener());
        this.olayout.addComponentDetachListener((HasComponents.ComponentDetachListener)new MyDetachListener());
        this.gridlayout = new GridLayout();
        this.gridlayout.addComponentAttachListener((HasComponents.ComponentAttachListener)new MyAttachListener());
        this.gridlayout.addComponentDetachListener((HasComponents.ComponentDetachListener)new MyDetachListener());
        this.absolutelayout = new AbsoluteLayout();
        this.absolutelayout.addComponentAttachListener((HasComponents.ComponentAttachListener)new MyAttachListener());
        this.absolutelayout.addComponentDetachListener((HasComponents.ComponentDetachListener)new MyDetachListener());
        this.csslayout = new CssLayout();
        this.csslayout.addComponentAttachListener((HasComponents.ComponentAttachListener)new MyAttachListener());
        this.csslayout.addComponentDetachListener((HasComponents.ComponentDetachListener)new MyDetachListener());
        this.customlayout = new CustomLayout("<div location='loc'/>");
        this.customlayout.addComponentAttachListener((HasComponents.ComponentAttachListener)new MyAttachListener());
        this.customlayout.addComponentDetachListener((HasComponents.ComponentDetachListener)new MyDetachListener());
    }

    @Test
    public void testOrderedLayoutAttachListener() {
        this.resetVariables();
        Label comp = new Label();
        this.olayout.addComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.attachCounter);
        Assert.assertSame((Object)comp, (Object)this.attachedComponent);
        Assert.assertSame((Object)this.olayout, (Object)this.attachTarget);
        Assert.assertTrue((boolean)this.foundInContainer);
        Assert.assertFalse((this.indexOfComponent == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderedLayoutDetachListener() {
        Label comp = new Label();
        this.olayout.addComponent((Component)comp);
        this.resetVariables();
        this.olayout.removeComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.detachCounter);
        Assert.assertSame((Object)comp, (Object)this.detachedComponent);
        Assert.assertSame((Object)this.olayout, (Object)this.detachedTarget);
        Assert.assertFalse((boolean)this.foundInContainer);
        Assert.assertEquals((long)-1L, (long)this.indexOfComponent);
    }

    @Test
    public void testGridLayoutAttachListener() {
        this.resetVariables();
        Label comp = new Label();
        this.gridlayout.addComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.attachCounter);
        Assert.assertSame((Object)comp, (Object)this.attachedComponent);
        Assert.assertSame((Object)this.gridlayout, (Object)this.attachTarget);
        Assert.assertTrue((boolean)this.foundInContainer);
        Assert.assertNotNull((Object)this.componentArea);
    }

    @Test
    public void testGridLayoutDetachListener() {
        Label comp = new Label();
        this.gridlayout.addComponent((Component)comp);
        this.resetVariables();
        this.gridlayout.removeComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.detachCounter);
        Assert.assertSame((Object)comp, (Object)this.detachedComponent);
        Assert.assertSame((Object)this.gridlayout, (Object)this.detachedTarget);
        Assert.assertFalse((boolean)this.foundInContainer);
        Assert.assertNull((Object)this.componentArea);
    }

    @Test
    public void testAbsoluteLayoutAttachListener() {
        this.resetVariables();
        Label comp = new Label();
        this.absolutelayout.addComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.attachCounter);
        Assert.assertSame((Object)comp, (Object)this.attachedComponent);
        Assert.assertSame((Object)this.absolutelayout, (Object)this.attachTarget);
        Assert.assertTrue((boolean)this.foundInContainer);
        Assert.assertNotNull((Object)this.componentPosition);
    }

    @Test
    public void testAbsoluteLayoutDetachListener() {
        Label comp = new Label();
        this.absolutelayout.addComponent((Component)comp);
        this.resetVariables();
        this.absolutelayout.removeComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.detachCounter);
        Assert.assertSame((Object)comp, (Object)this.detachedComponent);
        Assert.assertSame((Object)this.absolutelayout, (Object)this.detachedTarget);
        Assert.assertFalse((boolean)this.foundInContainer);
        Assert.assertNull((Object)this.componentPosition);
    }

    @Test
    public void testCSSLayoutAttachListener() {
        this.resetVariables();
        Label comp = new Label();
        this.csslayout.addComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.attachCounter);
        Assert.assertSame((Object)comp, (Object)this.attachedComponent);
        Assert.assertSame((Object)this.csslayout, (Object)this.attachTarget);
        Assert.assertTrue((boolean)this.foundInContainer);
    }

    @Test
    public void testCSSLayoutDetachListener() {
        Label comp = new Label();
        this.csslayout.addComponent((Component)comp);
        this.resetVariables();
        this.csslayout.removeComponent((Component)comp);
        Assert.assertEquals((long)1L, (long)this.detachCounter);
        Assert.assertSame((Object)comp, (Object)this.detachedComponent);
        Assert.assertSame((Object)this.csslayout, (Object)this.detachedTarget);
        Assert.assertFalse((boolean)this.foundInContainer);
    }

    @Test
    public void testCustomLayoutAttachListener() {
        this.resetVariables();
        Label comp = new Label();
        this.customlayout.addComponent((Component)comp, "loc");
        Assert.assertEquals((String)"Attach counter should get incremented", (long)1L, (long)this.attachCounter);
        Assert.assertSame((String)"The attached component should be the label", (Object)comp, (Object)this.attachedComponent);
        Assert.assertSame((String)"The attached target should be the layout", (Object)this.customlayout, (Object)this.attachTarget);
        Assert.assertTrue((String)"The attached component should be found in the container", (boolean)this.foundInContainer);
    }

    @Test
    public void testCustomLayoutDetachListener() {
        Label comp = new Label();
        this.customlayout.addComponent((Component)comp);
        this.resetVariables();
        this.customlayout.removeComponent((Component)comp);
        Assert.assertEquals((String)"Detach counter should get incremented", (long)1L, (long)this.detachCounter);
        Assert.assertSame((String)"The detached component should be the label", (Object)comp, (Object)this.detachedComponent);
        Assert.assertSame((String)"The detached target should be the layout", (Object)this.customlayout, (Object)this.detachedTarget);
        Assert.assertFalse((String)"The detached component should not be found in the container", (boolean)this.foundInContainer);
    }

    private class MyDetachListener
    implements HasComponents.ComponentDetachListener {
        private MyDetachListener() {
        }

        public void componentDetachedFromContainer(HasComponents.ComponentDetachEvent event) {
            ComponentAttachDetachListenerTest.this.detachCounter++;
            ComponentAttachDetachListenerTest.this.detachedComponent = event.getDetachedComponent();
            ComponentAttachDetachListenerTest.this.detachedTarget = event.getContainer();
            for (Component c : ComponentAttachDetachListenerTest.this.detachedTarget) {
                if (c != ComponentAttachDetachListenerTest.this.detachedComponent) continue;
                ComponentAttachDetachListenerTest.this.foundInContainer = true;
                break;
            }
            if (ComponentAttachDetachListenerTest.this.detachedTarget instanceof AbstractOrderedLayout) {
                ComponentAttachDetachListenerTest.this.indexOfComponent = ((AbstractOrderedLayout)ComponentAttachDetachListenerTest.this.detachedTarget).getComponentIndex(ComponentAttachDetachListenerTest.this.detachedComponent);
            } else if (ComponentAttachDetachListenerTest.this.detachedTarget instanceof GridLayout) {
                ComponentAttachDetachListenerTest.this.componentArea = ((GridLayout)ComponentAttachDetachListenerTest.this.detachedTarget).getComponentArea(ComponentAttachDetachListenerTest.this.detachedComponent);
            } else if (ComponentAttachDetachListenerTest.this.detachedTarget instanceof AbsoluteLayout) {
                ComponentAttachDetachListenerTest.this.componentPosition = ((AbsoluteLayout)ComponentAttachDetachListenerTest.this.detachedTarget).getPosition(ComponentAttachDetachListenerTest.this.detachedComponent);
            }
        }
    }

    private class MyAttachListener
    implements HasComponents.ComponentAttachListener {
        private MyAttachListener() {
        }

        public void componentAttachedToContainer(HasComponents.ComponentAttachEvent event) {
            ComponentAttachDetachListenerTest.this.attachCounter++;
            ComponentAttachDetachListenerTest.this.attachedComponent = event.getAttachedComponent();
            ComponentAttachDetachListenerTest.this.attachTarget = event.getContainer();
            for (Component c : ComponentAttachDetachListenerTest.this.attachTarget) {
                if (c != ComponentAttachDetachListenerTest.this.attachedComponent) continue;
                ComponentAttachDetachListenerTest.this.foundInContainer = true;
                break;
            }
            if (ComponentAttachDetachListenerTest.this.attachTarget instanceof AbstractOrderedLayout) {
                ComponentAttachDetachListenerTest.this.indexOfComponent = ((AbstractOrderedLayout)ComponentAttachDetachListenerTest.this.attachTarget).getComponentIndex(ComponentAttachDetachListenerTest.this.attachedComponent);
            } else if (ComponentAttachDetachListenerTest.this.attachTarget instanceof GridLayout) {
                ComponentAttachDetachListenerTest.this.componentArea = ((GridLayout)ComponentAttachDetachListenerTest.this.attachTarget).getComponentArea(ComponentAttachDetachListenerTest.this.attachedComponent);
            } else if (ComponentAttachDetachListenerTest.this.attachTarget instanceof AbsoluteLayout) {
                ComponentAttachDetachListenerTest.this.componentPosition = ((AbsoluteLayout)ComponentAttachDetachListenerTest.this.attachTarget).getPosition(ComponentAttachDetachListenerTest.this.attachedComponent);
            }
        }
    }
}

