/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.componentcontainer;

import com.vaadin.tests.server.componentcontainer.AbstractIndexedLayoutTestBase;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import org.junit.Assert;
import org.junit.Test;

public class HorizontalLayoutTest
extends AbstractIndexedLayoutTestBase {
    @Override
    protected Layout createLayout() {
        return new HorizontalLayout();
    }

    public HorizontalLayout getLayout() {
        return (HorizontalLayout)super.getLayout();
    }

    @Override
    protected Component getComponent(int index) {
        return this.getLayout().getComponent(index);
    }

    @Override
    protected int getComponentIndex(Component c) {
        return this.getLayout().getComponentIndex(c);
    }

    @Override
    protected int getComponentCount() {
        return this.getLayout().getComponentCount();
    }

    @Test
    public void addAndExpand_basicCase() {
        Button b1 = new Button();
        Button b2 = new Button();
        Button b3 = new Button();
        HorizontalLayout layout = this.getLayout();
        layout.addComponents(new Component[]{b3, b2});
        layout.addComponentsAndExpand(new Component[]{b1, b2});
        Assert.assertEquals((long)3L, (long)layout.getComponentCount());
        Assert.assertSame((Object)b3, (Object)layout.getComponent(0));
        Assert.assertSame((Object)b1, (Object)layout.getComponent(1));
        Assert.assertSame((Object)b2, (Object)layout.getComponent(2));
        Assert.assertEquals((float)0.0f, (float)layout.getExpandRatio((Component)b3), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)layout.getExpandRatio((Component)b1), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)layout.getExpandRatio((Component)b2), (float)0.0f);
        Assert.assertEquals((float)-1.0f, (float)b3.getWidth(), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)b1.getWidth(), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)b2.getWidth(), (float)0.0f);
    }

    @Test
    public void addAndExpand_undefinedHeightUpdated() {
        HorizontalLayout layout = this.getLayout();
        Assert.assertEquals((float)-1.0f, (float)layout.getWidth(), (float)0.0f);
        layout.addComponentsAndExpand(new Component[0]);
        Assert.assertEquals((float)100.0f, (float)layout.getWidth(), (float)0.0f);
    }

    @Test
    public void addAndExpand_definedHeightPreserved() {
        HorizontalLayout layout = this.getLayout();
        layout.setWidth("150px");
        layout.addComponentsAndExpand(new Component[0]);
        Assert.assertEquals((float)150.0f, (float)layout.getWidth(), (float)0.0f);
    }
}

