/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.componentcontainer;

import com.vaadin.tests.VaadinClasses;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AddRemoveComponentTest {
    @Test
    public void testRemoveComponentFromWrongContainer() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<Class<? extends ComponentContainer>> containerClasses = VaadinClasses.getComponentContainersSupportingAddRemoveComponent();
        Assert.assertFalse((boolean)containerClasses.isEmpty());
        containerClasses.remove(CustomLayout.class);
        this.testRemoveComponentFromWrongContainer((ComponentContainer)new CustomLayout("dummy"));
        for (Class<? extends ComponentContainer> clazz : containerClasses) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            try {
                Constructor<? extends ComponentContainer> constructor = clazz.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.testRemoveComponentFromWrongContainer(constructor.newInstance(new Object[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    private void testRemoveComponentFromWrongContainer(ComponentContainer componentContainer) {
        HorizontalLayout hl = new HorizontalLayout();
        Label label = new Label();
        hl.addComponent((Component)label);
        componentContainer.removeComponent((Component)label);
        Assert.assertEquals((String)("Parent no longer correct for " + componentContainer.getClass()), (Object)hl, (Object)label.getParent());
    }
}

