/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.window;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class AttachDetachWindowTest {
    private final VaadinSession testApp = new AlwaysLockedVaadinSession(null);
    TestUI main = new TestUI();
    TestWindow sub = new TestWindow();

    @Test
    public void addSubWindowBeforeAttachingMainWindow() {
        this.assertUnattached(this.main);
        this.assertUnattached(this.sub);
        this.main.addWindow(this.sub);
        this.assertUnattached(this.main);
        this.assertUnattached(this.sub);
        this.main.setSession(this.testApp);
        this.assertAttached(this.main);
        this.assertAttached(this.sub);
    }

    @Test
    public void addSubWindowAfterAttachingMainWindow() {
        this.assertUnattached(this.main);
        this.assertUnattached(this.sub);
        this.main.setSession(this.testApp);
        this.assertAttached(this.main);
        this.assertUnattached(this.sub);
        this.main.addWindow(this.sub);
        this.assertAttached(this.main);
        this.assertAttached(this.sub);
    }

    @Test
    public void removeSubWindowBeforeDetachingMainWindow() {
        this.main.setSession(this.testApp);
        this.main.addWindow(this.sub);
        this.main.removeWindow(this.sub);
        this.assertAttached(this.main);
        this.assertDetached(this.sub);
        this.main.setSession(null);
        this.assertDetached(this.main);
        this.assertDetached(this.sub);
    }

    @Test
    public void removeSubWindowAfterDetachingMainWindow() {
        this.main.setSession(this.testApp);
        this.main.addWindow(this.sub);
        this.main.setSession(null);
        this.assertDetached(this.main);
        this.assertDetached(this.sub);
        this.main.removeWindow(this.sub);
        this.assertDetached(this.main);
        this.assertDetached(this.sub);
    }

    @Test
    public void addWindow_attachEventIsFired() {
        TestUI ui = new TestUI();
        Window window = new Window();
        boolean[] eventFired = new boolean[1];
        ui.addComponentAttachListener((HasComponents.ComponentAttachListener & Serializable)event -> {
            eventFired[0] = event.getAttachedComponent().equals(window);
        });
        ui.addWindow(window);
        Assert.assertTrue((String)"Attach event is not fired for added window", (boolean)eventFired[0]);
    }

    @Test
    public void removeWindow_detachEventIsFired() {
        TestUI ui = new TestUI();
        Window window = new Window();
        boolean[] eventFired = new boolean[1];
        ui.addComponentDetachListener((HasComponents.ComponentDetachListener & Serializable)event -> {
            eventFired[0] = event.getDetachedComponent().equals(window);
        });
        ui.addWindow(window);
        ui.removeWindow(window);
        Assert.assertTrue((String)"Detach event is not fired for removed window", (boolean)eventFired[0]);
    }

    private void assertAttached(TestContainer win) {
        TestContent testContent = win.getTestContent();
        Assert.assertTrue((String)"window attach not called", (boolean)win.attachCalled());
        Assert.assertTrue((String)"window content attach not called", (boolean)testContent.contentAttachCalled);
        Assert.assertTrue((String)"window child attach not called", (boolean)testContent.childAttachCalled);
        Assert.assertSame((String)"window not attached", (Object)win.getSession(), (Object)this.testApp);
        Assert.assertSame((String)"window content not attached", (Object)testContent.getUI().getSession(), (Object)this.testApp);
        Assert.assertSame((String)"window children not attached", (Object)testContent.child.getUI().getSession(), (Object)this.testApp);
    }

    private void assertUnattached(TestContainer win) {
        Assert.assertSame((String)"window not detached", (Object)win.getSession(), null);
        Assert.assertSame((String)"window content not detached", (Object)this.getSession((ClientConnector)win.getTestContent()), null);
        Assert.assertSame((String)"window children not detached", (Object)this.getSession((ClientConnector)win.getTestContent().child), null);
    }

    private VaadinSession getSession(ClientConnector testContainer) {
        UI ui = testContainer.getUI();
        if (ui != null) {
            return ui.getSession();
        }
        return null;
    }

    private void assertDetached(TestContainer win) {
        this.assertUnattached(win);
        Assert.assertTrue((String)"window detach not called", (boolean)win.detachCalled());
        Assert.assertTrue((String)"window content detach not called", (boolean)win.getTestContent().contentDetachCalled);
        Assert.assertTrue((String)"window child detach not called", (boolean)win.getTestContent().childDetachCalled);
    }

    private class TestUI
    extends UI
    implements TestContainer {
        boolean rootAttachCalled = false;
        boolean rootDetachCalled = false;
        private final TestContent testContent = new TestContent();

        public TestUI() {
            this.setContent((Component)this.testContent);
        }

        protected void init(VaadinRequest request) {
        }

        @Override
        public boolean attachCalled() {
            return this.rootAttachCalled;
        }

        @Override
        public boolean detachCalled() {
            return this.rootDetachCalled;
        }

        @Override
        public TestContent getTestContent() {
            return this.testContent;
        }

        public void attach() {
            super.attach();
            this.rootAttachCalled = true;
        }

        public void detach() {
            super.detach();
            this.rootDetachCalled = true;
        }
    }

    private class TestContent
    extends VerticalLayout {
        boolean contentDetachCalled = false;
        boolean childDetachCalled = false;
        boolean contentAttachCalled = false;
        boolean childAttachCalled = false;
        private final Label child = new Label(){

            public void attach() {
                super.attach();
                TestContent.this.childAttachCalled = true;
            }

            public void detach() {
                super.detach();
                TestContent.this.childDetachCalled = true;
            }
        };

        public TestContent() {
            this.addComponent((Component)this.child);
        }

        public void attach() {
            super.attach();
            this.contentAttachCalled = true;
        }

        public void detach() {
            super.detach();
            this.contentDetachCalled = true;
        }
    }

    private class TestWindow
    extends Window
    implements TestContainer {
        boolean windowAttachCalled = false;
        boolean windowDetachCalled = false;
        private final TestContent testContent = new TestContent();

        TestWindow() {
            this.setContent((Component)this.testContent);
        }

        public void attach() {
            super.attach();
            this.windowAttachCalled = true;
        }

        public void detach() {
            super.detach();
            this.windowDetachCalled = true;
        }

        @Override
        public boolean attachCalled() {
            return this.windowAttachCalled;
        }

        @Override
        public boolean detachCalled() {
            return this.windowDetachCalled;
        }

        @Override
        public TestContent getTestContent() {
            return this.testContent;
        }

        @Override
        public VaadinSession getSession() {
            return super.getSession();
        }
    }

    private static interface TestContainer {
        public boolean attachCalled();

        public boolean detachCalled();

        public TestContent getTestContent();

        public VaadinSession getSession();
    }
}

