/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.upload;

import com.vaadin.server.StreamVariable;
import com.vaadin.shared.ui.upload.UploadState;
import com.vaadin.ui.Upload;
import org.junit.Assert;
import org.junit.Test;

public class UploadTest {
    @Test
    public void getStreamVariable_streamingFailed_endUploadIsCalled() {
        TestUpload upload = new TestUpload();
        upload.startUpload();
        StreamVariable variable = upload.getStreamVariable();
        try {
            variable.streamingFailed((StreamVariable.StreamingErrorEvent)new TestStreamingErrorEvent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)upload.isUploading());
    }

    @Test
    public void setImmediateMode_defaultTrue() {
        Upload upload = new Upload();
        Assert.assertTrue((String)"Upload should be in immediate mode by default", (boolean)upload.isImmediateMode());
    }

    @Test
    public void getState_uploadHasCustomState() {
        TestUpload upload = new TestUpload();
        UploadState state = upload.getState();
        Assert.assertEquals((String)"Unexpected state class", UploadState.class, state.getClass());
    }

    @Test
    public void getPrimaryStyleName_uploadHasCustomPrimaryStyleName() {
        Upload upload = new Upload();
        UploadState state = new UploadState();
        Assert.assertEquals((String)"Unexpected primary style name", (Object)state.primaryStyleName, (Object)upload.getPrimaryStyleName());
    }

    @Test
    public void uploadStateHasCustomPrimaryStyleName() {
        UploadState state = new UploadState();
        Assert.assertEquals((String)"Unexpected primary style name", (Object)"v-upload", (Object)state.primaryStyleName);
    }

    private static class TestUpload
    extends Upload {
        private TestUpload() {
        }

        public StreamVariable getStreamVariable() {
            return super.getStreamVariable();
        }

        public UploadState getState() {
            return super.getState();
        }

        protected void fireNoInputStream(String filename, String MIMEType, long length) {
            this.fireEvent();
        }

        protected void fireNoOutputStream(String filename, String MIMEType, long length) {
            this.fireEvent();
        }

        protected void fireUploadInterrupted(String filename, String MIMEType, long length, Exception e) {
            this.fireEvent();
        }

        private void fireEvent() {
            throw new NullPointerException();
        }
    }

    private static class TestStreamingErrorEvent
    implements StreamVariable.StreamingErrorEvent {
        private TestStreamingErrorEvent() {
        }

        public String getFileName() {
            return null;
        }

        public String getMimeType() {
            return null;
        }

        public long getContentLength() {
            return 0L;
        }

        public long getBytesReceived() {
            return 0L;
        }

        public Exception getException() {
            return new Exception();
        }
    }
}

