/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.ui;

import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.LegacyWindow;
import org.junit.Assert;
import org.junit.Test;

public class LegacyUIAddRemoveComponentsTest {
    @Test
    public void addComponent() {
        TestUI ui = new TestUI();
        Label c = new Label("abc");
        ui.addComponent((Component)c);
        Assert.assertSame((Object)c.getParent(), ui.iterator().next());
        Assert.assertSame((Object)c, ui.getContent().iterator().next());
        Assert.assertEquals((long)1L, (long)ui.getComponentCount());
        Assert.assertEquals((long)1L, (long)ui.getContent().getComponentCount());
    }

    @Test
    public void removeComponent() {
        TestUI ui = new TestUI();
        Label c = new Label("abc");
        ui.addComponent((Component)c);
        ui.removeComponent((Component)c);
        Assert.assertEquals((Object)ui.getContent(), ui.iterator().next());
        Assert.assertFalse((boolean)ui.getContent().iterator().hasNext());
        Assert.assertEquals((long)1L, (long)ui.getComponentCount());
        Assert.assertEquals((long)0L, (long)ui.getContent().getComponentCount());
    }

    @Test
    public void replaceComponent() {
        TestUI ui = new TestUI();
        Label c = new Label("abc");
        Label d = new Label("def");
        ui.addComponent((Component)c);
        ui.replaceComponent((Component)c, (Component)d);
        Assert.assertSame((Object)d.getParent(), ui.iterator().next());
        Assert.assertSame((Object)d, ui.getContent().iterator().next());
        Assert.assertEquals((long)1L, (long)ui.getComponentCount());
        Assert.assertEquals((long)1L, (long)ui.getContent().getComponentCount());
    }

    private static class TestUI
    extends LegacyWindow {
        private TestUI() {
        }

        protected void init(VaadinRequest request) {
        }
    }
}

