/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.tree;

import com.vaadin.data.SelectionModel;
import com.vaadin.data.TreeData;
import com.vaadin.data.provider.HierarchicalQuery;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.server.component.abstractcomponent.AbstractComponentDeclarativeTestBase;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.IconGenerator;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Tree;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class TreeDeclarativeTest
extends AbstractComponentDeclarativeTestBase<Tree> {
    @Test
    public void dataSerialization() {
        Person person1 = this.createPerson("a");
        Person person2 = this.createPerson("a/a");
        Person person3 = this.createPerson("a/b");
        Person person4 = this.createPerson("a/b/c");
        Person person5 = this.createPerson("b");
        TreeData data = new TreeData();
        data.addItems(null, (Object[])new Person[]{person1, person5});
        data.addItems((Object)person1, (Object[])new Person[]{person2, person3});
        data.addItem((Object)person3, (Object)person4);
        Tree tree = new Tree();
        tree.setTreeData(data);
        tree.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> item.getFirstName());
        String designString = String.format("<%s><node item='%s'>%s</node><node item='%s' parent='%s'>%s</node><node item='%s' parent='%s'>%s</node><node item='%s' parent='%s'>%s</node><node item='%s'>%s</node></%s>", this.getComponentTag(), person1.toString(), person1.getFirstName(), person2.toString(), person1.toString(), person2.getFirstName(), person3.toString(), person1.toString(), person3.getFirstName(), person4.toString(), person3.toString(), person4.getFirstName(), person5.toString(), person5.getFirstName(), this.getComponentTag());
        this.testWrite(designString, tree, true);
        Tree readTree = this.testRead(designString, tree);
        Assert.assertEquals((long)2L, (long)readTree.getDataProvider().getChildCount(new HierarchicalQuery(null, null)));
        Assert.assertEquals((long)2L, (long)readTree.getDataProvider().getChildCount(new HierarchicalQuery(null, (Object)person1.toString())));
        Assert.assertEquals((long)1L, (long)readTree.getDataProvider().getChildCount(new HierarchicalQuery(null, (Object)person3.toString())));
    }

    @Test
    public void htmlContentMode() {
        Person person = this.createPerson("A Person");
        Tree tree = new Tree();
        tree.setItems((Object[])new Person[]{person});
        tree.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> String.format("<b>%s</b>", item.getFirstName()));
        tree.setContentMode(ContentMode.HTML);
        String designString = String.format("<%s content-mode='html'><node item='%s'><b>%s</b></node></%s>", this.getComponentTag(), person.toString(), person.getFirstName(), this.getComponentTag());
        this.testWrite(designString, tree, true);
        this.testRead(designString, tree);
    }

    @Test
    public void selectionMode() {
        Tree tree = new Tree();
        tree.setSelectionMode(Grid.SelectionMode.MULTI);
        String designString = String.format("<%s selection-mode='multi'></%s>", this.getComponentTag(), this.getComponentTag());
        this.testRead(designString, tree);
        this.testWrite(designString, tree, false);
    }

    @Override
    @Test
    public void heightFullDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s size-full/>", this.getComponentTag());
        Tree tree = new Tree();
        tree.setHeight("100%");
        this.testRead(design, tree);
        this.testWrite(design, tree);
    }

    @Override
    @Test
    public void sizeUndefinedDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s size-auto/>", this.getComponentTag());
        Tree tree = new Tree();
        tree.setSizeUndefined();
        this.testRead(design, tree);
        this.testWrite(design, tree);
    }

    @Override
    @Test
    public void widthFullDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s/>", this.getComponentTag());
        Tree tree = new Tree();
        tree.setWidth("100%");
        this.testRead(design, tree);
        this.testWrite(design, tree);
    }

    @Override
    @Test
    public void widthUndefinedDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s size-auto/>", this.getComponentTag());
        Tree tree = new Tree();
        tree.setWidthUndefined();
        this.testRead(design, tree);
        this.testWrite(design, tree);
    }

    @Test
    public void testUpdateExisting() {
        Tree tree = new Tree();
        String treeDesign = "<vaadin-tree selection-mode=\"MULTI\"><node item=\"A\">A</node><node item=\"B\">B</node><node item=\"AA\" parent=\"A\">AA</node></vaadin-tree>";
        Design.read((InputStream)new ByteArrayInputStream(treeDesign.getBytes()), (Component)tree);
        try (Stream stream = tree.getDataProvider().fetchChildren(new HierarchicalQuery(null, null));){
            Object[] items = stream.toArray();
            Assert.assertArrayEquals((Object[])new Object[]{"A", "B"}, (Object[])items);
        }
        stream = tree.getDataProvider().fetchChildren(new HierarchicalQuery(null, (Object)"A"));
        try {
            Object[] itemsA = stream.toArray();
            Assert.assertArrayEquals((Object[])new Object[]{"AA"}, (Object[])itemsA);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = tree.getDataProvider().fetchChildren(new HierarchicalQuery(null, (Object)"B"));
        try {
            long countB = stream.count();
            Assert.assertEquals((long)0L, (long)countB);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        Assert.assertTrue((boolean)(tree.getSelectionModel() instanceof SelectionModel.Multi));
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-tree";
    }

    @Override
    protected Class<? extends Tree> getComponentClass() {
        return Tree.class;
    }

    @Override
    protected void assertEqualsCustom(String message, Object o1, Object o2) {
        if (o1 instanceof ItemCaptionGenerator) {
            Assert.assertTrue((boolean)(o2 instanceof ItemCaptionGenerator));
            return;
        }
        if (o1 instanceof IconGenerator) {
            Assert.assertTrue((boolean)(o2 instanceof IconGenerator));
            return;
        }
        super.assertEqualsCustom(message, o1, o2);
    }

    private Person createPerson(String name) {
        Person person = new Person();
        person.setFirstName(name);
        return person;
    }
}

