/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.textarea;

import com.vaadin.tests.server.component.abstracttextfield.AbstractTextFieldDeclarativeTest;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.declarative.DesignContext;
import java.io.IOException;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Test;

public class TextAreaDeclarativeTest
extends AbstractTextFieldDeclarativeTest<TextArea> {
    @Override
    public void valueDeserialization() throws InstantiationException, IllegalAccessException {
        String value = "Hello World!";
        String design = String.format("<%s>%s</%s>", this.getComponentTag(), value, this.getComponentTag());
        TextArea component = new TextArea();
        component.setValue(value);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Override
    public void readOnlyValue() throws InstantiationException, IllegalAccessException {
        String value = "Hello World!";
        String design = String.format("<%s readonly>%s</%s>", this.getComponentTag(), value, this.getComponentTag());
        TextArea component = new TextArea();
        component.setValue(value);
        component.setReadOnly(true);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void testHtmlEntities() throws IOException {
        String design = "<vaadin-text-area>&amp; Test</vaadin-text-area>";
        TextArea read = (TextArea)this.read(design);
        Assert.assertEquals((Object)"& Test", (Object)read.getValue());
        read.setValue("&amp; Test");
        DesignContext dc = new DesignContext();
        Element root = new Element(Tag.valueOf((String)"vaadin-text-area"), "");
        read.writeDesign(root, dc);
        Assert.assertEquals((Object)"&amp;amp; Test", (Object)root.html());
    }

    @Test
    public void remainingAttriburesDeserialization() {
        int rows = 11;
        boolean wrap = false;
        String design = String.format("<%s rows='%s' word-wrap='%s'/>", this.getComponentTag(), rows, wrap);
        TextArea component = new TextArea();
        component.setRows(rows);
        component.setWordWrap(wrap);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-text-area";
    }

    @Override
    protected Class<TextArea> getComponentClass() {
        return TextArea.class;
    }
}

