/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.tabsheet;

import com.vaadin.server.ClientConnector;
import com.vaadin.shared.ui.tabsheet.TabsheetServerRpc;
import com.vaadin.shared.ui.tabsheet.TabsheetState;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentTest;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class TabSheetTest {
    @Test
    public void addExistingComponent() {
        Label c = new Label("abc");
        TabSheet tabSheet = new TabSheet();
        tabSheet.addComponent((Component)c);
        tabSheet.addComponent((Component)c);
        Iterator iter = tabSheet.getComponentIterator();
        Assert.assertEquals((Object)c, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertNotNull((Object)tabSheet.getTab((Component)c));
    }

    @Test
    public void getComponentFromTab() {
        Label c = new Label("abc");
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab = tabSheet.addTab((Component)c);
        Assert.assertEquals((Object)c, (Object)tab.getComponent());
    }

    @Test
    public void addTabWithComponentOnly() {
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab1 = tabSheet.addTab((Component)new Label("aaa"));
        TabSheet.Tab tab2 = tabSheet.addTab((Component)new Label("bbb"));
        TabSheet.Tab tab3 = tabSheet.addTab((Component)new Label("ccc"));
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab3));
        tabSheet.addTab(tab1.getComponent());
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab3));
    }

    @Test
    public void addTabWithComponentAndIndex() {
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab1 = tabSheet.addTab((Component)new Label("aaa"));
        TabSheet.Tab tab2 = tabSheet.addTab((Component)new Label("bbb"));
        TabSheet.Tab tab3 = tabSheet.addTab((Component)new Label("ccc"));
        TabSheet.Tab tab4 = tabSheet.addTab((Component)new Label("ddd"), 1);
        TabSheet.Tab tab5 = tabSheet.addTab((Component)new Label("eee"), 3);
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab4));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)3L, (long)tabSheet.getTabPosition(tab5));
        Assert.assertEquals((long)4L, (long)tabSheet.getTabPosition(tab3));
        tabSheet.addTab(tab1.getComponent(), 3);
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab4));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)3L, (long)tabSheet.getTabPosition(tab5));
        Assert.assertEquals((long)4L, (long)tabSheet.getTabPosition(tab3));
    }

    @Test
    public void addTabWithAllParameters() {
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab1 = tabSheet.addTab((Component)new Label("aaa"));
        TabSheet.Tab tab2 = tabSheet.addTab((Component)new Label("bbb"));
        TabSheet.Tab tab3 = tabSheet.addTab((Component)new Label("ccc"));
        TabSheet.Tab tab4 = tabSheet.addTab((Component)new Label("ddd"), "ddd", null, 1);
        TabSheet.Tab tab5 = tabSheet.addTab((Component)new Label("eee"), "eee", null, 3);
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab4));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)3L, (long)tabSheet.getTabPosition(tab5));
        Assert.assertEquals((long)4L, (long)tabSheet.getTabPosition(tab3));
        tabSheet.addTab(tab1.getComponent(), "xxx", null, 3);
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tab1));
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tab4));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tab2));
        Assert.assertEquals((long)3L, (long)tabSheet.getTabPosition(tab5));
        Assert.assertEquals((long)4L, (long)tabSheet.getTabPosition(tab3));
    }

    @Test
    public void getTabByPosition() {
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab1 = tabSheet.addTab((Component)new Label("aaa"));
        TabSheet.Tab tab2 = tabSheet.addTab((Component)new Label("bbb"));
        TabSheet.Tab tab3 = tabSheet.addTab((Component)new Label("ccc"));
        Assert.assertEquals((Object)tab1, (Object)tabSheet.getTab(0));
        Assert.assertEquals((Object)tab2, (Object)tabSheet.getTab(1));
        Assert.assertEquals((Object)tab3, (Object)tabSheet.getTab(2));
        Assert.assertEquals(null, (Object)tabSheet.getTab(3));
    }

    @Test
    public void selectTab() {
        TabSheet tabSheet = new TabSheet();
        TabSheet.Tab tab1 = tabSheet.addTab((Component)new Label("aaa"));
        TabSheet.Tab tab2 = tabSheet.addTab((Component)new Label("bbb"));
        TabSheet.Tab tab3 = tabSheet.addTab((Component)new Label("ccc"));
        Label componentNotInSheet = new Label("ddd");
        TabSheet.Tab tabNotInSheet = new TabSheet().addTab((Component)new Label("eee"));
        Assert.assertEquals((Object)tab1.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab(tab2.getComponent());
        Assert.assertEquals((Object)tab2.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab(tab3);
        Assert.assertEquals((Object)tab3.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab(0);
        Assert.assertEquals((Object)tab1.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab((Component)componentNotInSheet);
        Assert.assertEquals((Object)tab1.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab(tabNotInSheet);
        Assert.assertEquals((Object)tab1.getComponent(), (Object)tabSheet.getSelectedTab());
        tabSheet.setSelectedTab(123);
        Assert.assertEquals((Object)tab1.getComponent(), (Object)tabSheet.getSelectedTab());
    }

    @Test
    public void replaceComponent() {
        TabSheet tabSheet = new TabSheet();
        Label lbl1 = new Label("aaa");
        Label lbl2 = new Label("bbb");
        Label lbl3 = new Label("ccc");
        Label lbl4 = new Label("ddd");
        TabSheet.Tab tab1 = tabSheet.addTab((Component)lbl1);
        tab1.setCaption("tab1");
        tab1.setClosable(true);
        TabSheet.Tab tab2 = tabSheet.addTab((Component)lbl2);
        tab2.setDescription("description");
        tab2.setEnabled(false);
        tabSheet.replaceComponent((Component)lbl3, (Component)lbl2);
        Assert.assertEquals((long)2L, (long)tabSheet.getComponentCount());
        Assert.assertSame((Object)tab1, (Object)tabSheet.getTab((Component)lbl1));
        Assert.assertSame((Object)tab2, (Object)tabSheet.getTab((Component)lbl2));
        Assert.assertNull((Object)tabSheet.getTab((Component)lbl3));
        tabSheet.replaceComponent((Component)lbl3, (Component)lbl4);
        Assert.assertEquals((long)3L, (long)tabSheet.getComponentCount());
        Assert.assertSame((Object)tab1, (Object)tabSheet.getTab((Component)lbl1));
        Assert.assertSame((Object)tab2, (Object)tabSheet.getTab((Component)lbl2));
        Assert.assertEquals((long)2L, (long)tabSheet.getTabPosition(tabSheet.getTab((Component)lbl4)));
        tabSheet.replaceComponent((Component)lbl1, (Component)lbl2);
        Assert.assertSame((Object)tab1, (Object)tabSheet.getTab((Component)lbl1));
        Assert.assertSame((Object)tab2, (Object)tabSheet.getTab((Component)lbl2));
        Assert.assertFalse((boolean)tab1.isClosable());
        Assert.assertTrue((boolean)tab2.isClosable());
        Assert.assertFalse((boolean)tab1.isEnabled());
        Assert.assertTrue((boolean)tab2.isEnabled());
        Assert.assertEquals((Object)"description", (Object)tab1.getDescription());
        Assert.assertEquals(null, (Object)tab2.getDescription());
        Assert.assertEquals((long)3L, (long)tabSheet.getComponentCount());
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tabSheet.getTab((Component)lbl1)));
        Assert.assertEquals((long)0L, (long)tabSheet.getTabPosition(tabSheet.getTab((Component)lbl2)));
        tabSheet.replaceComponent((Component)lbl1, (Component)lbl3);
        Assert.assertEquals((long)3L, (long)tabSheet.getComponentCount());
        Assert.assertNull((Object)tabSheet.getTab((Component)lbl1));
        Assert.assertNull((Object)tab1.getComponent());
        Assert.assertNotNull((Object)tabSheet.getTab((Component)lbl3));
        Assert.assertFalse((boolean)tabSheet.getTab((Component)lbl3).isEnabled());
        Assert.assertEquals((Object)"description", (Object)tab1.getDescription());
        Assert.assertEquals((long)1L, (long)tabSheet.getTabPosition(tabSheet.getTab((Component)lbl3)));
    }

    @Test
    public void testSelectedTabChangeEvent_whenComponentReplaced() {
        TabSheet tabSheet = new TabSheet();
        Label lbl1 = new Label("aaa");
        Label lbl2 = new Label("bbb");
        Label lbl3 = new Label("ccc");
        Label lbl4 = new Label("ddd");
        tabSheet.addComponent((Component)lbl1);
        tabSheet.addComponent((Component)lbl2);
        tabSheet.addComponent((Component)lbl3);
        tabSheet.setSelectedTab((Component)lbl2);
        final class SelectedTabExpectedComponentListener
        implements TabSheet.SelectedTabChangeListener {
            private Component actualComponent;

            SelectedTabExpectedComponentListener() {
            }

            public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                this.actualComponent = event.getTabSheet().getSelectedTab();
            }

            public void assertActualComponentIs(Component expectedComponent) {
                Assert.assertEquals((Object)expectedComponent, (Object)this.actualComponent);
                this.actualComponent = null;
            }
        }
        SelectedTabExpectedComponentListener listener = new SelectedTabExpectedComponentListener();
        tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)listener);
        tabSheet.replaceComponent((Component)lbl2, (Component)lbl4);
        listener.assertActualComponentIs((Component)lbl4);
        Assert.assertEquals((Object)lbl4, (Object)tabSheet.getSelectedTab());
        tabSheet.replaceComponent((Component)lbl1, (Component)lbl2);
        Assert.assertEquals((Object)lbl4, (Object)tabSheet.getSelectedTab());
        tabSheet.replaceComponent((Component)lbl2, (Component)lbl3);
        Assert.assertEquals((Object)lbl4, (Object)tabSheet.getSelectedTab());
        tabSheet.replaceComponent((Component)lbl4, (Component)lbl3);
        listener.assertActualComponentIs((Component)lbl3);
        Assert.assertEquals((Object)lbl3, (Object)tabSheet.getSelectedTab());
    }

    @Test
    public void userOriginatedForSelectionEvent() {
        AtomicBoolean userOriginated = new AtomicBoolean(false);
        AtomicReference selected = new AtomicReference();
        Button b1 = new Button("b1");
        Button b2 = new Button("b2");
        Button b3 = new Button("b3");
        Button b4 = new Button("b4");
        TestTabsheet tabsheet = new TestTabsheet(new Component[]{b1, b2, b3, b4});
        tabsheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> {
            userOriginated.set(event.isUserOriginated());
            selected.set(event.getTabSheet().getSelectedTab());
        });
        tabsheet.setSelectedTab((Component)b2);
        Assert.assertFalse((boolean)userOriginated.get());
        Assert.assertEquals((Object)b2, selected.get());
        TabsheetServerRpc rpc = ComponentTest.getRpcProxy((ClientConnector)tabsheet, TabsheetServerRpc.class);
        rpc.setSelected(tabsheet.getKey((Component)b1));
        Assert.assertTrue((boolean)userOriginated.get());
        Assert.assertEquals((Object)b1, selected.get());
        tabsheet.setSelectedTab(tabsheet.getTab((Component)b4));
        Assert.assertFalse((boolean)userOriginated.get());
        Assert.assertEquals((Object)b4, selected.get());
    }

    public static class TestTabsheet
    extends TabSheet {
        public TestTabsheet(Component ... components) {
            super(components);
        }

        public String getKey(Component c) {
            return this.keyMapper.key((Object)c);
        }

        public TabsheetState getState() {
            return super.getState();
        }
    }
}

