/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.orderedlayout;

import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAlignmentTest {
    private VerticalLayout verticalLayout;
    private HorizontalLayout horizontalLayout;

    @Before
    public void setup() {
        this.verticalLayout = new VerticalLayout();
        this.horizontalLayout = new HorizontalLayout();
    }

    @Test
    public void testDefaultAlignmentVerticalLayout() {
        this.testDefaultAlignment((AbstractOrderedLayout)this.verticalLayout);
    }

    @Test
    public void testDefaultAlignmentHorizontalLayout() {
        this.testDefaultAlignment((AbstractOrderedLayout)this.horizontalLayout);
    }

    public void testDefaultAlignment(AbstractOrderedLayout layout) {
        Label label = new Label("A label");
        TextField tf = new TextField("A TextField");
        layout.addComponent((Component)label);
        layout.addComponent((Component)tf);
        Assert.assertEquals((Object)Alignment.TOP_LEFT, (Object)layout.getComponentAlignment((Component)label));
        Assert.assertEquals((Object)Alignment.TOP_LEFT, (Object)layout.getComponentAlignment((Component)tf));
    }

    @Test
    public void testAlteredDefaultAlignmentVerticalLayout() {
        this.testAlteredDefaultAlignment((AbstractOrderedLayout)this.verticalLayout);
    }

    @Test
    public void testAlteredDefaultAlignmentHorizontalLayout() {
        this.testAlteredDefaultAlignment((AbstractOrderedLayout)this.horizontalLayout);
    }

    public void testAlteredDefaultAlignment(AbstractOrderedLayout layout) {
        Label label = new Label("A label");
        TextField tf = new TextField("A TextField");
        layout.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        layout.addComponent((Component)label);
        layout.addComponent((Component)tf);
        Assert.assertEquals((Object)Alignment.MIDDLE_CENTER, (Object)layout.getComponentAlignment((Component)label));
        Assert.assertEquals((Object)Alignment.MIDDLE_CENTER, (Object)layout.getComponentAlignment((Component)tf));
    }
}

