/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.loginform;

import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.LoginForm;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoginFormTest {
    private LoginForm loginForm;

    @Before
    public void setup() {
        this.loginForm = new LoginForm();
    }

    @Test
    public void defaultCaptions() {
        Assert.assertEquals((Object)"Username", (Object)this.loginForm.getUsernameCaption());
        Assert.assertEquals((Object)"Password", (Object)this.loginForm.getPasswordCaption());
        Assert.assertEquals((Object)"Login", (Object)this.loginForm.getLoginButtonCaption());
    }

    @Test
    public void changeCaptionsBeforeAttach() {
        this.loginForm.setUsernameCaption("u");
        this.loginForm.setPasswordCaption("p");
        this.loginForm.setLoginButtonCaption("l");
        Assert.assertEquals((Object)"u", (Object)this.loginForm.getUsernameCaption());
        Assert.assertEquals((Object)"p", (Object)this.loginForm.getPasswordCaption());
        Assert.assertEquals((Object)"l", (Object)this.loginForm.getLoginButtonCaption());
    }

    @Test
    public void changeCaptionsAfterAttach() {
        MockUI ui = new MockUI();
        ui.setContent((Component)this.loginForm);
        this.loginForm.setUsernameCaption("u");
        this.loginForm.setPasswordCaption("p");
        this.loginForm.setLoginButtonCaption("l");
        Assert.assertEquals((Object)"u", (Object)this.loginForm.getUsernameCaption());
        Assert.assertEquals((Object)"p", (Object)this.loginForm.getPasswordCaption());
        Assert.assertEquals((Object)"l", (Object)this.loginForm.getLoginButtonCaption());
    }

    @Test
    public void changeCaptionsBeforeAndAfterAttach() {
        this.loginForm.setUsernameCaption("a");
        this.loginForm.setPasswordCaption("a");
        this.loginForm.setLoginButtonCaption("a");
        MockUI ui = new MockUI();
        ui.setContent((Component)this.loginForm);
        this.loginForm.setUsernameCaption("u");
        this.loginForm.setPasswordCaption("p");
        this.loginForm.setLoginButtonCaption("l");
        Assert.assertEquals((Object)"u", (Object)this.loginForm.getUsernameCaption());
        Assert.assertEquals((Object)"p", (Object)this.loginForm.getPasswordCaption());
        Assert.assertEquals((Object)"l", (Object)this.loginForm.getLoginButtonCaption());
    }

    @Test
    public void customizedFields() {
        LoginForm customForm = new LoginForm(){

            protected Button createLoginButton() {
                return new NativeButton("Do it");
            }

            protected TextField createUsernameField() {
                TextField tf = new TextField("Username caption");
                tf.setPlaceholder("Name goes here");
                return tf;
            }

            protected PasswordField createPasswordField() {
                PasswordField pf = new PasswordField("Password caption");
                pf.setPlaceholder("Secret goes here");
                return pf;
            }
        };
        MockUI ui = new MockUI();
        ui.setContent((Component)customForm);
        Iterator i = ((HasComponents)customForm.iterator().next()).iterator();
        Assert.assertEquals((Object)"Username caption", (Object)((Component)i.next()).getCaption());
        Assert.assertEquals((Object)"Password caption", (Object)((Component)i.next()).getCaption());
        Assert.assertEquals((Object)"Do it", (Object)((Component)i.next()).getCaption());
    }
}

