/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.gridlayout;

import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class GridLayoutTest {
    Component[] children = new Component[]{new Label("A"), new Label("B"), new Label("C"), new Label("D")};

    @Test
    public void testConstructorWithComponents() {
        GridLayout grid = new GridLayout(2, 2, this.children);
        this.assertContentPositions(grid);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3});
        grid = new GridLayout(1, 1, this.children);
        this.assertContentPositions(grid);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3});
    }

    @Test
    public void testAddComponents() {
        GridLayout grid = new GridLayout(2, 2);
        grid.addComponents(this.children);
        this.assertContentPositions(grid);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3});
        Label extra = new Label("Extra");
        Label extra2 = new Label("Extra2");
        grid.addComponents(new Component[]{extra, extra2});
        Assert.assertSame((Object)grid.getComponent(0, 2), (Object)extra);
        Assert.assertSame((Object)grid.getComponent(1, 2), (Object)extra2);
        grid.removeAllComponents();
        grid.addComponents(new Component[]{extra, extra2});
        Assert.assertSame((Object)grid.getComponent(0, 0), (Object)extra);
        Assert.assertSame((Object)grid.getComponent(1, 0), (Object)extra2);
        grid.addComponents(this.children);
        this.assertOrder((Layout)grid, new int[]{-1, -1, 0, 1, 2, 3});
        grid.removeComponent((Component)extra);
        grid.removeComponent((Component)extra2);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3});
        grid.addComponents(new Component[]{extra2, extra});
        Assert.assertSame((Object)grid.getComponent(0, 3), (Object)extra2);
        Assert.assertSame((Object)grid.getComponent(1, 3), (Object)extra);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3, -1, -1});
        grid.removeComponent((Component)extra2);
        grid.removeComponent((Component)extra);
        grid.setCursorX(0);
        grid.setCursorY(0);
        grid.addComponents(new Component[]{extra, extra2});
        Assert.assertSame((Object)grid.getComponent(0, 0), (Object)extra);
        Assert.assertSame((Object)grid.getComponent(1, 0), (Object)extra2);
        this.assertOrder((Layout)grid, new int[]{-1, -1, 0, 1, 2, 3});
        grid = new GridLayout();
        grid.addComponents(this.children);
        this.assertContentPositions(grid);
        this.assertOrder((Layout)grid, new int[]{0, 1, 2, 3});
    }

    @Test
    public void removeRowsExpandRatiosPreserved() {
        GridLayout gl = new GridLayout(3, 3);
        gl.setRowExpandRatio(0, 0.0f);
        gl.setRowExpandRatio(1, 1.0f);
        gl.setRowExpandRatio(2, 2.0f);
        gl.setRows(2);
        Assert.assertEquals((float)0.0f, (float)gl.getRowExpandRatio(0), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)gl.getRowExpandRatio(1), (float)0.0f);
    }

    @Test
    public void removeColsExpandRatiosPreserved() {
        GridLayout gl = new GridLayout(3, 3);
        gl.setColumnExpandRatio(0, 0.0f);
        gl.setColumnExpandRatio(1, 1.0f);
        gl.setColumnExpandRatio(2, 2.0f);
        gl.setColumns(2);
        Assert.assertEquals((float)0.0f, (float)gl.getColumnExpandRatio(0), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)gl.getColumnExpandRatio(1), (float)0.0f);
    }

    @Test
    public void verifyOutOfBoundsExceptionContainsHelpfulMessage() {
        GridLayout grid = new GridLayout(1, 1);
        try {
            grid.addComponent((Component)new Label(), 3, 3);
            Assert.fail((String)"Should have failed");
        }
        catch (GridLayout.OutOfBoundsException ex) {
            Assert.assertEquals((Object)"Area{3,3 - 3,3}, layout dimension: 1x1", (Object)ex.getMessage());
        }
    }

    @Test
    public void verifyAddComponentFailsWithHelpfulMessageOnInvalidArgs() {
        GridLayout grid = new GridLayout(6, 6);
        try {
            grid.addComponent((Component)new Label(), 3, 3, 2, 2);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Illegal coordinates for the component: 3!<=2, 3!<=2", (Object)ex.getMessage());
        }
    }

    private void assertContentPositions(GridLayout grid) {
        Assert.assertEquals((long)grid.getComponentCount(), (long)this.children.length);
        int c = 0;
        for (int i = 0; i < grid.getRows(); ++i) {
            for (int j = 0; j < grid.getColumns(); ++j) {
                Assert.assertSame((Object)grid.getComponent(j, i), (Object)this.children[c]);
                ++c;
            }
        }
    }

    private void assertOrder(Layout layout, int[] indices) {
        Iterator i = layout.iterator();
        try {
            for (int index : indices) {
                if (index != -1) {
                    Assert.assertSame((Object)this.children[index], i.next());
                    continue;
                }
                i.next();
            }
            Assert.assertFalse((String)"Too many components in layout", (boolean)i.hasNext());
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)"Too few components in layout");
        }
    }
}

