/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.HeaderCell;
import com.vaadin.ui.components.grid.HeaderRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridDefaultHeaderTest {
    private Grid<String> grid;
    private Grid.Column<?, ?> column1;
    private Grid.Column<?, ?> column2;

    @Before
    public void setUp() {
        this.grid = new Grid();
        this.column1 = this.grid.addColumn(ValueProvider.identity()).setId("First").setCaption("First");
        this.column2 = this.grid.addColumn(ValueProvider.identity()).setId("Second").setCaption("Second");
    }

    @Test
    public void initialState_hasDefaultHeader() {
        HeaderRow defaultHeader = this.grid.getDefaultHeaderRow();
        Assert.assertEquals((long)1L, (long)this.grid.getHeaderRowCount());
        Assert.assertSame((Object)this.grid.getHeaderRow(0), (Object)defaultHeader);
        Assert.assertEquals((Object)"First", (Object)defaultHeader.getCell(this.column1).getText());
        Assert.assertEquals((Object)"Second", (Object)defaultHeader.getCell(this.column2).getText());
    }

    @Test
    public void initialState_defaultHeaderRemovable() {
        this.grid.removeHeaderRow(0);
        Assert.assertEquals((long)0L, (long)this.grid.getHeaderRowCount());
        Assert.assertNull((Object)this.grid.getDefaultHeaderRow());
    }

    @Test
    public void initialState_updateColumnCaption_defaultHeaderUpdated() {
        this.column1.setCaption("1st");
        Assert.assertEquals((Object)"1st", (Object)this.grid.getDefaultHeaderRow().getCell(this.column1).getText());
    }

    @Test
    public void customDefaultHeader_updateColumnCaption_defaultHeaderUpdated() {
        this.grid.setDefaultHeaderRow(this.grid.appendHeaderRow());
        this.column1.setCaption("1st");
        Assert.assertEquals((Object)"1st", (Object)this.grid.getDefaultHeaderRow().getCell(this.column1).getText());
        Assert.assertEquals((Object)"First", (Object)this.grid.getHeaderRow(0).getCell(this.column1).getText());
    }

    @Test
    public void noDefaultRow_updateColumnCaption_headerNotUpdated() {
        this.grid.setDefaultHeaderRow(null);
        this.column1.setCaption("1st");
        Assert.assertEquals((Object)"First", (Object)this.grid.getHeaderRow(0).getCell(this.column1).getText());
    }

    @Test
    public void updateDefaultRow_columnCaptionUpdated() {
        this.grid.getDefaultHeaderRow().getCell(this.column1).setText("new");
        Assert.assertEquals((Object)"new", (Object)this.column1.getCaption());
        Assert.assertEquals((Object)"Second", (Object)this.column2.getCaption());
    }

    @Test
    public void updateDefaultRowWithMergedCell_columnCaptionNotUpdated() {
        HeaderCell merged = this.grid.getDefaultHeaderRow().join(new Grid.Column[]{this.column1, this.column2});
        merged.setText("new");
        Assert.assertEquals((Object)"First", (Object)this.column1.getCaption());
        Assert.assertEquals((Object)"Second", (Object)this.column2.getCaption());
    }

    @Test
    public void updateColumnCaption_defaultRowWithMergedCellNotUpdated() {
        HeaderCell merged = this.grid.getDefaultHeaderRow().join(new Grid.Column[]{this.column1, this.column2});
        merged.setText("new");
        this.column1.setCaption("foo");
        this.column2.setCaption("bar");
        Assert.assertEquals((Object)"new", (Object)merged.getText());
    }
}

