/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.components.grid.FooterCell;
import com.vaadin.ui.components.grid.HeaderCell;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridChildrenTest {
    private Grid<Person> grid;

    @Before
    public void createGrid() {
        this.grid = new Grid();
        this.grid.addColumn(Person::getFirstName).setId("foo");
        this.grid.addColumn(Person::getLastName).setId("bar");
        this.grid.addColumn(Person::getEmail).setId("baz");
    }

    @Test
    public void iteratorFindsComponentsInMergedHeader() {
        HeaderCell merged = this.grid.getDefaultHeaderRow().join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Iterator i = this.grid.iterator();
        Assert.assertEquals((Object)label, i.next());
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void removeComponentInMergedHeaderCell() {
        HeaderCell merged = this.grid.getDefaultHeaderRow().join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Assert.assertEquals(this.grid, (Object)label.getParent());
        merged.setText("foo");
        Assert.assertNull((Object)label.getParent());
    }

    @Test
    public void removeHeaderWithComponentInMergedHeaderCell() {
        HeaderCell merged = this.grid.getDefaultHeaderRow().join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Assert.assertEquals(this.grid, (Object)label.getParent());
        this.grid.removeHeaderRow(0);
        Assert.assertNull((Object)label.getParent());
    }

    @Test
    public void removeComponentInMergedFooterCell() {
        FooterCell merged = this.grid.addFooterRowAt(0).join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Assert.assertEquals(this.grid, (Object)label.getParent());
        merged.setText("foo");
        Assert.assertNull((Object)label.getParent());
    }

    @Test
    public void removeFooterWithComponentInMergedFooterCell() {
        FooterCell merged = this.grid.addFooterRowAt(0).join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Assert.assertEquals(this.grid, (Object)label.getParent());
        this.grid.removeFooterRow(0);
        Assert.assertNull((Object)label.getParent());
    }

    @Test
    public void componentsInMergedFooter() {
        FooterCell merged = this.grid.addFooterRowAt(0).join(new String[]{"foo", "bar", "baz"});
        Label label = new Label();
        merged.setComponent((Component)label);
        Iterator i = this.grid.iterator();
        Assert.assertEquals((Object)label, i.next());
        Assert.assertFalse((boolean)i.hasNext());
        Assert.assertEquals(this.grid, (Object)label.getParent());
    }
}

