/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.customlayout;

import com.vaadin.ui.CustomLayout;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class CustomLayoutTest {
    @Test
    public void ctor_inputStreamProvided_inputStreamIsRead() throws IOException, IllegalArgumentException, IllegalAccessException {
        Integer buffer = this.getBufferSize();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < buffer; ++i) {
            builder.append('a');
        }
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        InputStreamImpl stream = new InputStreamImpl(inputStream, buffer / 2);
        new CustomLayout((InputStream)stream);
        Assert.assertTrue((String)"Stream is not closed in CustomLayout CTOR ", (boolean)stream.isClosed());
        Assert.assertEquals((String)"Number of read bytes is incorrect", (long)bytes.length, (long)stream.getCount());
    }

    private Integer getBufferSize() throws IllegalAccessException {
        Field[] fields = CustomLayout.class.getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if ((field.getModifiers() & 8) <= 0) continue;
            list.add(field);
        }
        Field field = null;
        if (list.size() == 1) {
            field = (Field)list.get(0);
        } else {
            for (Field fld : list) {
                if (!fld.getName().toLowerCase(Locale.ROOT).startsWith("buffer")) continue;
                field = fld;
                break;
            }
        }
        Assert.assertNotNull((String)"Unable to find default buffer size in CustomLayout class", (Object)field);
        field.setAccessible(true);
        Integer buffer = (Integer)field.get(null);
        return buffer;
    }

    private static class InputStreamImpl
    extends FilterInputStream {
        private int readCount;
        private boolean isClosed;
        private final int maxArrayLength;

        InputStreamImpl(InputStream inputStream, int maxArrayLength) {
            super(inputStream);
            this.maxArrayLength = maxArrayLength;
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            if (read != -1) {
                ++this.readCount;
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b.length > this.maxArrayLength) {
                return this.read(b, 0, this.maxArrayLength);
            }
            int count = super.read(b);
            if (count != -1) {
                this.readCount += count;
            }
            return count;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len > this.maxArrayLength) {
                return this.read(b, off, this.maxArrayLength);
            }
            int count = super.read(b, off, len);
            if (count != -1) {
                this.readCount += count;
            }
            return count;
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
            super.close();
        }

        int getCount() {
            return this.readCount;
        }

        boolean isClosed() {
            return this.isClosed;
        }
    }
}

