/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.csslayout;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import org.junit.Test;

public class CssLayoutDeclarativeTest
extends DeclarativeTestBase<CssLayout> {
    @Test
    public void testNoChildren() {
        String design = "<vaadin-css-layout />";
        CssLayout layout = new CssLayout();
        this.testRead(design, layout);
        this.testWrite(design, layout);
        design = "<vaadin-css-layout caption=\"A caption\"/>";
        layout = new CssLayout();
        layout.setCaption("A caption");
        this.testRead(design, layout);
        this.testWrite(design, layout);
    }

    @Test
    public void testFeatures() {
        String design = "<vaadin-css-layout caption=test-layout><vaadin-label caption=test-label /><vaadin-button>test-button</vaadin-button></vaadin-css-layout>";
        CssLayout layout = new CssLayout();
        layout.setCaption("test-layout");
        Label l = new Label();
        l.setContentMode(ContentMode.HTML);
        l.setCaption("test-label");
        layout.addComponent((Component)l);
        Button b = new Button("test-button");
        b.setCaptionAsHtml(true);
        layout.addComponent((Component)b);
        this.testRead(design, layout);
        this.testWrite(design, layout);
    }
}

