/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.combobox;

import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.ClientMethodInvocation;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.ui.combobox.ComboBoxServerRpc;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.ui.ComboBox;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComboBoxFilteringTest {
    private static final String[] PERSON_NAMES = new String[]{"Enrique Iglesias", "Henry Dunant", "Erwin Engelbrecht"};
    private ComboBox<Person> comboBox;

    @Before
    public void setup() {
        this.comboBox = new ComboBox();
        this.comboBox.setLocale(Locale.US);
    }

    @Test
    public void setItems_array_defaultFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setItems((Object[])this.getPersonArray());
        this.checkFiltering("en", "ennen", 3, 2);
    }

    @Test
    public void setItems_array_setItemCaptionAfterItems() {
        this.comboBox.setItems((Object[])this.getPersonArray());
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.checkFiltering("en", "ennen", 3, 2);
    }

    @Test
    public void setItems_collection_defaultFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setItems(this.getPersonCollection());
        this.checkFiltering("en", "ennen", 3, 2);
    }

    @Test
    public void setItems_collection_setItemCaptionAfterItems() {
        this.comboBox.setItems(this.getPersonCollection());
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.checkFiltering("en", "ennen", 3, 2);
    }

    @Test
    public void setItems_array_customFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setItems(String::startsWith, (Object[])this.getPersonArray());
        this.checkFiltering("En", "en", 3, 1);
    }

    @Test
    public void setItems_collection_customFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setItems(String::startsWith, this.getPersonCollection());
        this.checkFiltering("En", "en", 3, 1);
    }

    @Test
    public void setListDataProvider_defaultFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setDataProvider(DataProvider.ofCollection(this.getPersonCollection()));
        this.checkFiltering("en", "ennen", 3, 2);
    }

    @Test
    public void setListDataProvider_customFiltering() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        this.comboBox.setDataProvider(String::startsWith, DataProvider.ofCollection(this.getPersonCollection()));
        this.checkFiltering("En", "en", 3, 1);
    }

    public void invalid_dataProvider_compile_error() {
        DataProvider dp = DataProvider.ofItems((Object[])this.getPersonArray()).filteringByEquals(Person::getAddress);
    }

    @Test
    public void customDataProvider_filterByLastName() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        ListDataProvider ldp = DataProvider.ofItems((Object[])this.getPersonArray());
        this.comboBox.setDataProvider(ldp.withConvertedFilter((SerializableFunction & Serializable)text -> (SerializablePredicate & Serializable)person -> person.getLastName().contains((CharSequence)text)));
        this.checkFiltering("u", "ab", 3, 1);
    }

    @Test
    public void customDataProvider_filterByLastNameWithAccessRestriction() {
        this.comboBox.setItemCaptionGenerator(Person::getFirstName);
        ListDataProvider ldp = DataProvider.ofItems((Object[])this.getPersonArray());
        ldp.setFilter((SerializablePredicate & Serializable)person -> person.getFirstName().contains("nr"));
        this.comboBox.setDataProvider(ldp.withConvertedFilter((SerializableFunction & Serializable)text -> (SerializablePredicate & Serializable)person -> person.getLastName().contains((CharSequence)text)));
        this.checkFiltering("t", "Engel", 2, 1);
    }

    @Test
    public void filterEmptyComboBox() {
        this.checkFiltering("foo", "bar", 0, 0);
    }

    @Test
    public void setListDataProvider_notWrapped() {
        ListDataProvider provider = new ListDataProvider(Collections.emptyList());
        this.comboBox.setDataProvider(provider);
        Assert.assertSame((Object)provider, (Object)this.comboBox.getDataProvider());
    }

    @Test
    public void setItems_hasListDataProvider() {
        this.comboBox.setItems((Object[])new Person[0]);
        Assert.assertEquals(ListDataProvider.class, this.comboBox.getDataProvider().getClass());
    }

    private void checkFiltering(String filterText, String nonMatchingFilterText, int totalMatches, int matchingResults) {
        Assert.assertEquals((String)"ComboBox filtered out results with no filter applied", (long)totalMatches, (long)this.comboBoxSizeWithFilter(null));
        Assert.assertEquals((String)"ComboBox filtered out results with empty filter string", (long)totalMatches, (long)this.comboBoxSizeWithFilter(""));
        Assert.assertEquals((String)"ComboBox filtered out wrong number of results", (long)matchingResults, (long)this.comboBoxSizeWithFilter(filterText));
        Assert.assertEquals((String)"ComboBox should have no results with a non-matching filter", (long)0L, (long)this.comboBoxSizeWithFilter(nonMatchingFilterText));
    }

    private int comboBoxSizeWithFilter(String filter) {
        DataCommunicator dataCommunicator = this.comboBox.getDataCommunicator();
        dataCommunicator.retrievePendingRpcCalls();
        ((ComboBoxServerRpc)ServerRpcManager.getRpcProxy(this.comboBox, ComboBoxServerRpc.class)).setFilter(filter);
        dataCommunicator.beforeClientResponse(true);
        ClientMethodInvocation resetInvocation = (ClientMethodInvocation)dataCommunicator.retrievePendingRpcCalls().get(0);
        assert (resetInvocation.getMethodName().equals("reset"));
        return (Integer)resetInvocation.getParameters()[0];
    }

    private List<Person> getPersonCollection() {
        return Stream.of(PERSON_NAMES).map(name -> new Person(name.split(" ")[0], name.split(" ")[1], null, 0, Sex.MALE, null)).collect(Collectors.toList());
    }

    private Person[] getPersonArray() {
        return this.getPersonCollection().toArray(new Person[PERSON_NAMES.length]);
    }
}

