/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.components.colorpicker.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RGBPatternParsingTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public int expectedRed;
    @Parameterized.Parameter(value=2)
    public int expectedGreen;
    @Parameterized.Parameter(value=3)
    public int expectedBlue;
    @Parameterized.Parameter(value=4)
    public boolean expectedMatches;

    @Parameterized.Parameters(name="{index}: testRGBData({0}) = ({1},{2},{3},{4})")
    public static Collection<Object[]> rgbdata() {
        Object[][] validValues = new Object[][]{{"rgb(0,0,0)", 0, 0, 0, true}, {"rgb(0, 0, 0)", 0, 0, 0, true}, {"rgb(0 0 0)", 0, 0, 0, true}, {"rgb(1 1 1)", 1, 1, 1, true}, {"rgb(0 100 255)", 0, 100, 255, true}, {"rgb(255,255,255)", 255, 255, 255, true}, {"RGB(255, 255, 255 )", 255, 255, 255, true}, {"rgb(255 255 255)", 255, 255, 255, true}, {"rgb(1, 10, 100)", 1, 10, 100, true}};
        Object[][] invalidValues = new Object[][]{{"rgb(,0,0)", 0, 0, 0, false}, {"rgb(0, 0, 0, )", 0, 0, 0, false}, {"rgb(0.0,0,0)", 0, 0, 0, false}, {"rgb( 0 0 -1 )", 0, 0, 0, false}, {"rgb(1 00)", 0, 0, 0, false}, {"rgb(255,255,255.)", 0, 0, 0, false}, {"r gb(255, 256, 255)", 0, 0, 0, false}, {"rgb( 255, 255, 256 )", 0, 0, 0, false}, {"rgb(163, 2%, 210)", 0, 0, 0, false}, {"rGb(000)", 0, 0, 0, false}, {"rgb(255255255)", 0, 0, 0, false}, {"rGBA(255,255,255)", 0, 0, 0, false}, {"rgb 255 255 255)", 0, 0, 0, false}, {"255, 255, 0", 0, 0, 0, false}, {"hsl(10,0,0)", 0, 0, 0, false}, {"\\s%\\d[0-9]", 0, 0, 0, false}, {"rgb(\\.*,255,255)", 0, 0, 0, false}, {"#\\d.*", 0, 0, 0, false}, {"", 0, 0, 0, false}, {"rgb(\\d,\\d,\\d)", 0, 0, 0, false}, {"^rgb\\( \\.*)", 0, 0, 0, false}};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Collections.addAll(values, validValues);
        Collections.addAll(values, invalidValues);
        return values;
    }

    @Test
    public void testRGBData() {
        Matcher m = ColorUtil.RGB_PATTERN.matcher(this.input);
        boolean matches = m.matches();
        if (this.expectedMatches) {
            Color expectedColor = new Color(this.expectedRed, this.expectedGreen, this.expectedBlue);
            Color c1 = ColorUtil.getRGBPatternColor((Matcher)m);
            Assert.assertTrue((boolean)expectedColor.equals((Object)c1));
        } else {
            Assert.assertTrue((!matches ? 1 : 0) != 0);
        }
    }
}

