/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.components.colorpicker.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RGBAPatternParsingTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public int expectedRed;
    @Parameterized.Parameter(value=2)
    public int expectedGreen;
    @Parameterized.Parameter(value=3)
    public int expectedBlue;
    @Parameterized.Parameter(value=4)
    public int expectedAlpha;
    @Parameterized.Parameter(value=5)
    public boolean expectedMatches;

    @Parameterized.Parameters(name="{index}: testRGBAData({0}) = ({1},{2},{3},{4},{5})")
    public static Collection<Object[]> rgbdata() {
        Object[][] validValues = new Object[][]{{"rgba(0,0,0,0)", 0, 0, 0, 0, true}, {"RGBA(0, 0, 0, 0 )", 0, 0, 0, 0, true}, {"rgba(0 0 0 0.00)", 0, 0, 0, 0, true}, {"rgba(1 1 1 1.00)", 1, 1, 1, 255, true}, {"rgba(0 100 200 0.50)", 0, 100, 200, 127, true}, {"rgba(255,255,255,1.0)", 255, 255, 255, 255, true}, {"rgba(255, 255, 255, 1.0)", 255, 255, 255, 255, true}, {"rgba(255 255 255 0)", 255, 255, 255, 0, true}, {"rgba(1, 10, 100, 0.00)", 1, 10, 100, 0, true}};
        Object[][] invalidValues = new Object[][]{{"rgba(256,0,0,0)", 0, 0, 0, 0, false}, {"rgba(0, 256, 0, -0 )", 0, 0, 0, 0, false}, {"rgba(0,0,10.0, 00)", 0, 0, 0, 0, false}, {"rgba(0 0 0 2.00)", 0, 0, 0, 0, false}, {"rgba(0 -99 0 0.50)", 0, 0, 0, 0, false}, {"rgba(0,255%,255,1.0)", 0, 0, 0, 0, false}, {"rgba(255, 255, 255, 1.05)", 0, 0, 0, 0, false}, {"rgba(255, 255, 255, 1.50)", 0, 0, 0, 0, false}, {"rgb a(255 255 0.005)", 0, 0, 0, 0, false}, {"rgba(163, 256, 1000, 0.24)", 0, 0, 0, 0, false}, {"rgba(100, 0.5, 250, 0.8)", 0, 0, 0, 0, false}, {"rgba(, 50, 0, 0.6)", 0, 0, 0, 0, false}, {"rgba(200, 50, 0, 10.6)", 0, 0, 0, 0, false}, {"rgba 200, 50, 0, 1.", 0, 0, 0, 0, false}, {"rgba(0,0,0,0.)", 0, 0, 0, 0, false}, {"rgb(200, 50, 0)", 0, 0, 0, 0, false}, {"hsla,0(10,0,0)", 0, 0, 0, 0, false}, {"rgba(\\s.*\\d[0-9])", 0, 0, 0, 0, false}, {"rgba(\\.*,255,255, 0)", 0, 0, 0, 0, false}, {"#\\d.*", 0, 0, 0, 0, false}, {"", 0, 0, 0, 0, false}, {"rgba(\\d,\\d,\\d,0.0)", 0, 0, 0, 0, false}, {"^rgba\\( \\.*)", 0, 0, 0, 0, false}};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Collections.addAll(values, validValues);
        Collections.addAll(values, invalidValues);
        return values;
    }

    @Test
    public void testRGBAData() {
        Matcher m = ColorUtil.RGBA_PATTERN.matcher(this.input);
        boolean matches = m.matches();
        if (this.expectedMatches) {
            Color expectedColor = new Color(this.expectedRed, this.expectedGreen, this.expectedBlue, this.expectedAlpha);
            Color c1 = ColorUtil.getRGBAPatternColor((Matcher)m);
            Assert.assertTrue((boolean)expectedColor.equals((Object)c1));
        } else {
            Assert.assertTrue((!matches ? 1 : 0) != 0);
        }
    }
}

