/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.components.colorpicker.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HSLAPatternParsingTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public int expectedHue;
    @Parameterized.Parameter(value=2)
    public int expectedSaturation;
    @Parameterized.Parameter(value=3)
    public int expectedLight;
    @Parameterized.Parameter(value=4)
    public int expectedAlpha;
    @Parameterized.Parameter(value=5)
    public boolean expectedMatches;

    @Parameterized.Parameters(name="{index}: testHSLAData({0}) = ({1},{2},{3},{4},{5})")
    public static Collection<Object[]> hsladata() {
        Object[][] validValues = new Object[][]{{"hsla(0,0,0,0)", 0, 0, 0, 0, true}, {"HSLA(0, 0, 0, 0)", 0, 0, 0, 0, true}, {"hsla(0,0%,0%, 0.1)", 0, 0, 0, 25, true}, {"hsla(0 0 0 0.00 )", 0, 0, 0, 0, true}, {"hsla(0 0% 0% 0.50)", 0, 0, 0, 127, true}, {"hsla(360,100,100,1.0)", 360, 100, 100, 255, true}, {"hsla(360, 100, 100, 1.0)", 360, 100, 100, 255, true}, {"hsla(360, 100%, 100%, 1.00)", 360, 100, 100, 255, true}, {"hsla(360 100% 100% 1.00)", 360, 100, 100, 255, true}, {"hsla(20, 10, 10, 0.24)", 20, 10, 10, 61, true}, {"hsla(100, 0, 50, 0.8)", 100, 0, 50, 204, true}, {"hsla(269, 50, 0, .6)", 269, 50, 0, 153, true}};
        Object[][] invalidValues = new Object[][]{{"hsla(361,0,0,0)", 0, 0, 0, 0, false}, {"hsla(0.0, 0, 0, 0)", 0, 0, 0, 0, false}, {"hsla(0,0%,0%, 1.1)", 0, 0, 0, 0, false}, {"hsla(0 0 0 0.009 )", 0, 0, 0, 0, false}, {"hsla(0 0% -100% 0.50)", 0, 0, 0, 0, false}, {"hsla(360,1000,100,1.0)", 0, 0, 0, 0, false}, {"hsla(0, 100, 100, 2.0)", 0, 0, 0, 0, false}, {"hsla(360, 100%, 100%, 10.00)", 0, 0, 0, 0, false}, {"hsl a(360 100% 100% 1.)", 0, 0, 0, 0, false}, {"hsla(20, -10, 10, 0.24)", 0, 0, 0, 0, false}, {"hsla(400, 0, 50, 0.8)", 0, 0, 0, 0, false}, {"hsla(200, 50, 0, 0.996)", 0, 0, 0, 0, false}, {"hsla 200, 50, 0, 0.9", 0, 0, 0, 0, false}, {"hsla(0,0,0,0.)", 0, 0, 0, 0, false}};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Collections.addAll(values, validValues);
        Collections.addAll(values, invalidValues);
        return values;
    }

    @Test
    public void testHSLAData() {
        Matcher m = ColorUtil.HSLA_PATTERN.matcher(this.input);
        boolean matches = m.matches();
        if (this.expectedMatches) {
            Color expectedColor = new Color(Color.HSLtoRGB((int)this.expectedHue, (int)this.expectedSaturation, (int)this.expectedLight));
            expectedColor.setAlpha(this.expectedAlpha);
            Color c1 = ColorUtil.getHSLAPatternColor((Matcher)m);
            Assert.assertTrue((boolean)expectedColor.equals((Object)c1));
        } else {
            Assert.assertTrue((!matches ? 1 : 0) != 0);
        }
    }
}

