/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import org.junit.Assert;
import org.junit.Test;

public class ColorConversionsTest {
    @Test
    public void convertHSL2RGB() {
        int rgb = Color.HSLtoRGB((int)100, (int)50, (int)50);
        Color c = new Color(rgb);
        Assert.assertEquals((long)106L, (long)c.getRed());
        Assert.assertEquals((long)191L, (long)c.getGreen());
        Assert.assertEquals((long)64L, (long)c.getBlue());
        Assert.assertEquals((Object)"#6abf40", (Object)c.getCSS());
        rgb = Color.HSLtoRGB((int)0, (int)50, (int)50);
        c = new Color(rgb);
        Assert.assertEquals((long)191L, (long)c.getRed());
        Assert.assertEquals((long)64L, (long)c.getGreen());
        Assert.assertEquals((long)64L, (long)c.getBlue());
        Assert.assertEquals((Object)"#bf4040", (Object)c.getCSS());
        rgb = Color.HSLtoRGB((int)50, (int)0, (int)50);
        c = new Color(rgb);
        Assert.assertEquals((long)128L, (long)c.getRed());
        Assert.assertEquals((long)128L, (long)c.getGreen());
        Assert.assertEquals((long)128L, (long)c.getBlue());
        Assert.assertEquals((Object)"#808080", (Object)c.getCSS());
        rgb = Color.HSLtoRGB((int)50, (int)100, (int)0);
        c = new Color(rgb);
        Assert.assertEquals((float)0.0f, (float)c.getRed(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)c.getGreen(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)c.getBlue(), (float)0.0f);
        Assert.assertEquals((Object)"#000000", (Object)c.getCSS());
    }
}

