/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.tests.server.component.abstractfield.AbstractFieldDeclarativeTest;
import com.vaadin.ui.AbstractColorPicker;
import org.junit.Test;

public abstract class AbstractColorPickerDeclarativeTest<T extends AbstractColorPicker>
extends AbstractFieldDeclarativeTest<T, Color> {
    @Test
    public void testAllAbstractColorPickerFeatures() throws InstantiationException, IllegalAccessException {
        boolean defaultCaption = true;
        AbstractColorPicker.PopupStyle popupStyle = AbstractColorPicker.PopupStyle.POPUP_SIMPLE;
        int x = 79;
        int y = 91;
        boolean rgbVisibility = false;
        boolean hsvVisibility = false;
        boolean swatchesVisibility = true;
        boolean historyVisibility = false;
        boolean textFieldVisibility = false;
        String design = String.format("<%s default-caption-enabled position='%s,%s' popup-style='%s' rgb-visibility='%s' hsv-visibility='%s' history-visibility='%s' textfield-visibility='%s'/>", this.getComponentTag(), x, y, popupStyle.toString(), rgbVisibility, hsvVisibility, historyVisibility, textFieldVisibility);
        AbstractColorPicker colorPicker = (AbstractColorPicker)this.getComponentClass().newInstance();
        colorPicker.setDefaultCaptionEnabled(defaultCaption);
        colorPicker.setPosition(x, y);
        colorPicker.setPopupStyle(popupStyle);
        colorPicker.setRGBVisibility(rgbVisibility);
        colorPicker.setHSVVisibility(hsvVisibility);
        colorPicker.setSwatchesVisibility(swatchesVisibility);
        colorPicker.setHistoryVisibility(historyVisibility);
        colorPicker.setTextfieldVisibility(textFieldVisibility);
        this.testWrite(design, colorPicker);
        this.testRead(design, colorPicker);
    }

    @Override
    public void valueDeserialization() throws InstantiationException, IllegalAccessException {
        String rgb = "fafafa";
        String design = String.format("<%s color='#%s'/>", this.getComponentTag(), rgb);
        AbstractColorPicker colorPicker = (AbstractColorPicker)this.getComponentClass().newInstance();
        int colorInt = Integer.parseInt(rgb, 16);
        colorPicker.setValue(new Color(colorInt));
        this.testWrite(design, colorPicker);
        this.testRead(design, colorPicker);
    }

    @Override
    public void readOnlyValue() throws InstantiationException, IllegalAccessException {
        String rgb = "fafafa";
        String design = String.format("<%s color='#%s' readonly/>", this.getComponentTag(), rgb);
        AbstractColorPicker colorPicker = (AbstractColorPicker)this.getComponentClass().newInstance();
        int colorInt = Integer.parseInt(rgb, 16);
        colorPicker.setValue(new Color(colorInt));
        colorPicker.setReadOnly(true);
        this.testWrite(design, colorPicker);
        this.testRead(design, colorPicker);
    }
}

