/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.checkboxgroup;

import com.vaadin.tests.server.component.abstractmultiselect.AbstractMultiSelectDeclarativeTest;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.ItemCaptionGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public class CheckBoxGroupDeclarativeTest
extends AbstractMultiSelectDeclarativeTest<CheckBoxGroup> {
    private static final String SIMPLE_HTML = "<span>foo</span>";
    private static final String HTML = "<div class='wrapper'><div>bar</div></div>";
    private static final String HTML_ENTITIES = "<b>a & b</b>";

    @Test
    public void serializeDataWithHtmlContentAllowed() {
        CheckBoxGroup group = new CheckBoxGroup();
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String design = String.format("<%s html-content-allowed>\n<option item='foo'>%s</option>\n<option item='bar'>%s</option><option item='foobar'>%s</option>", this.getComponentTag(), SIMPLE_HTML, HTML, HTML_ENTITIES.replace("&", "&amp;"), this.getComponentTag());
        group.setItems(items);
        group.setHtmlContentAllowed(true);
        group.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)item -> this.generateCaption((String)item, items));
        this.testRead(design, group, true);
        this.testWrite(design, group, true);
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-check-box-group";
    }

    @Override
    protected Class<CheckBoxGroup> getComponentClass() {
        return CheckBoxGroup.class;
    }

    private String generateCaption(String item, List<String> items) {
        int index = items.indexOf(item);
        switch (index) {
            case 0: {
                return SIMPLE_HTML;
            }
            case 1: {
                return HTML;
            }
            case 2: {
                return HTML_ENTITIES;
            }
        }
        return null;
    }
}

