/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.button;

import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Button;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.declarative.DesignContext;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Test;

public class ButtonDeclarativeTest
extends DeclarativeTestBase<Button> {
    @Test
    public void testEmptyPlainText() {
        String design = "<vaadin-button plain-text></vaadin-button>";
        this.testButtonAndNativeButton(design, false, "");
    }

    @Test
    public void testPlainTextCaption() {
        String design = "<vaadin-button plain-text>Click</vaadin-button>";
        this.testButtonAndNativeButton(design, false, "Click");
    }

    @Test
    public void testEmptyHtml() {
        String design = "<vaadin-button />";
        this.testButtonAndNativeButton(design, true, "");
    }

    @Test
    public void testHtmlCaption() {
        String design = "<vaadin-button><b>Click</b></vaadin-button>";
        this.testButtonAndNativeButton(design, true, "<b>Click</b>");
    }

    @Test
    public void testWithCaptionAttribute() {
        String design = "<vaadin-button caption=Caption>Click</vaadin-button>";
        String expectedWritten = "<vaadin-button>Click</vaadin-button>";
        this.testButtonAndNativeButton(design, true, "Click", expectedWritten);
    }

    @Test
    public void testWithOnlyCaptionAttribute() {
        String design = "<vaadin-button caption=Click/>";
        String expectedWritten = "<vaadin-button/>";
        this.testButtonAndNativeButton(design, true, "", expectedWritten);
    }

    @Test
    public void testHtmlEntitiesInCaption() {
        String designPlainText = "<vaadin-button plain-text=\"true\">&gt; One</vaadin-button>";
        String expectedCaptionPlainText = "> One";
        Button read = (Button)this.read(designPlainText);
        Assert.assertEquals((Object)expectedCaptionPlainText, (Object)read.getCaption());
        designPlainText = designPlainText.replace("vaadin-button", "vaadin-native-button");
        Button nativeButton = (Button)this.read(designPlainText);
        Assert.assertEquals((Object)expectedCaptionPlainText, (Object)nativeButton.getCaption());
        String designHtml = "<vaadin-button>&gt; One</vaadin-button>";
        String expectedCaptionHtml = "&gt; One";
        read = (Button)this.read(designHtml);
        Assert.assertEquals((Object)expectedCaptionHtml, (Object)read.getCaption());
        designHtml = designHtml.replace("vaadin-button", "vaadin-native-button");
        nativeButton = (Button)this.read(designHtml);
        Assert.assertEquals((Object)expectedCaptionHtml, (Object)nativeButton.getCaption());
        read = new Button("&amp; Test");
        read.setCaptionAsHtml(true);
        Element root = new Element(Tag.valueOf((String)"vaadin-button"), "");
        read.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp; Test", (Object)root.html());
        read.setCaptionAsHtml(false);
        root = new Element(Tag.valueOf((String)"vaadin-button"), "");
        read.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp;amp; Test", (Object)root.html());
    }

    public void testButtonAndNativeButton(String design, boolean html, String caption) {
        this.testButtonAndNativeButton(design, html, caption, design);
    }

    public void testButtonAndNativeButton(String design, boolean html, String caption, String expectedWritten) {
        Button b = new Button();
        b.setCaptionAsHtml(html);
        b.setCaption(caption);
        this.testRead(expectedWritten, b);
        this.testWrite(expectedWritten, b);
        design = design.replace("vaadin-button", "vaadin-native-button");
        expectedWritten = expectedWritten.replace("vaadin-button", "vaadin-native-button");
        NativeButton nb = new NativeButton();
        nb.setCaptionAsHtml(html);
        nb.setCaption(caption);
        this.testRead(expectedWritten, nb);
        this.testWrite(expectedWritten, nb);
    }

    @Test
    public void testAttributes() {
        String design = "<vaadin-button tabindex=3 plain-text icon-alt=OK click-shortcut=shift-ctrl-o></vaadin-button>";
        Button b = new Button("");
        b.setTabIndex(3);
        b.setIconAlternateText("OK");
        b.setClickShortcut(79, new int[]{17, 16});
        this.testRead(design, b);
        this.testWrite(design, b);
    }
}

