/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.button;

import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Button;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ButtonClickTest {
    private boolean clicked = false;

    @Test
    public void clickDetachedButton() {
        Button b = new Button();
        AtomicInteger counter = new AtomicInteger(0);
        b.addClickListener((Button.ClickListener & Serializable)event -> counter.incrementAndGet());
        b.click();
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void testClick() {
        this.getButton().click();
        Assert.assertTrue((String)"Button doesn't fire clicks", (boolean)this.clicked);
    }

    @Test
    public void testClickDisabled() {
        Button b = this.getButton();
        b.setEnabled(false);
        b.click();
        Assert.assertFalse((String)"Disabled button fires click events", (boolean)this.clicked);
    }

    private Button getButton() {
        Button b = new Button();
        UI ui = this.createUI();
        b.setParent((HasComponents)ui);
        this.addClickListener(b);
        return b;
    }

    private UI createUI() {
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        return ui;
    }

    private void addClickListener(Button b) {
        this.clicked = false;
        b.addClickListener((Button.ClickListener & Serializable)event -> {
            this.clicked = true;
        });
    }
}

