/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractsplitpanel;

import com.vaadin.server.Sizeable;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;
import org.junit.Test;

public class AbstractSplitPanelDeclarativeTest
extends DeclarativeTestBase<AbstractSplitPanel> {
    @Test
    public void testWithBothChildren() {
        String design = "<vaadin-horizontal-split-panel split-position=20.5% min-split-position=20% max-split-position=50px locked reversed> <vaadin-horizontal-layout /> <vaadin-vertical-layout /></vaadin-horizontal-split-panel>";
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        sp.setSplitPosition(20.5f, Sizeable.Unit.PERCENTAGE, true);
        sp.setMinSplitPosition(20.0f, Sizeable.Unit.PERCENTAGE);
        sp.setMaxSplitPosition(50.0f, Sizeable.Unit.PIXELS);
        sp.setLocked(true);
        sp.addComponent((Component)new HorizontalLayout());
        sp.addComponent((Component)new VerticalLayout());
        this.testRead(design, sp);
        this.testWrite(design, sp);
    }

    @Test
    public void testWithFirstChild() {
        String design = "<vaadin-vertical-split-panel><vaadin-horizontal-layout caption=\"First slot\"/></vaadin-vertical-split-panel>";
        VerticalSplitPanel sp = new VerticalSplitPanel();
        HorizontalLayout t = new HorizontalLayout();
        t.setCaption("First slot");
        sp.addComponent((Component)t);
        this.testRead(design, sp);
        this.testWrite(design, sp);
    }

    @Test
    public void testWithSecondChild() {
        String design = "<vaadin-horizontal-split-panel><vaadin-button :second>Second slot</vaadin-button></vaadin-vertical-split-panel>";
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        Button b = new Button("Second slot");
        b.setCaptionAsHtml(true);
        sp.setSecondComponent((Component)b);
        this.testRead(design, sp);
        this.testWrite(design, sp);
    }

    @Test
    public void testEmpty() {
        String design = "<vaadin-horizontal-split-panel/>";
        HorizontalSplitPanel sp = new HorizontalSplitPanel();
        this.testRead(design, sp);
        this.testWrite(design, sp);
    }
}

