/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractsingleselect;

import com.vaadin.tests.design.DeclarativeTestBaseBase;
import com.vaadin.tests.server.component.abstractlisting.AbstractListingDeclarativeTest;
import com.vaadin.ui.AbstractSingleSelect;
import com.vaadin.ui.Component;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.declarative.DesignContext;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSingleSelectDeclarativeTest<T extends AbstractSingleSelect>
extends AbstractListingDeclarativeTest<T> {
    @Override
    @Test
    public void dataSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String type = "com.vaadin.SomeType";
        String attribute = "data-type";
        String design = String.format("<%s %s='%s'>\n<option item='foo'>foo</option>\n<option item='bar' selected>bar</option><option item='foobar'>foobar</option></%s>", this.getComponentTag(), attribute, type, this.getComponentTag());
        AbstractSingleSelect component = (AbstractSingleSelect)this.getComponentClass().newInstance();
        component.setItems(items);
        component.setSelectedItem((Object)"bar");
        DesignContext context = this.readComponentAndCompare(design, component);
        Assert.assertEquals((Object)type, context.getCustomAttributes(context.getRootComponent()).get(attribute));
        context = new DesignContext();
        context.setCustomAttribute((Component)component, attribute, type);
        context.setShouldWriteDataDelegate(DeclarativeTestBaseBase.ALWAYS_WRITE_DATA);
        this.testWrite(component, design, context);
    }

    @Override
    @Test
    public void valueSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String type = "com.vaadin.SomeType";
        String attribute = "data-type";
        String design = String.format("<%s  %s='%s'>\n<option item='foo'>foo</option>\n<option item='bar' selected>bar</option><option item='foobar'>foobar</option></%s>", this.getComponentTag(), attribute, type, this.getComponentTag());
        AbstractSingleSelect component = (AbstractSingleSelect)this.getComponentClass().newInstance();
        component.setItems(items);
        component.setValue((Object)"bar");
        DesignContext context = this.readComponentAndCompare(design, component);
        Assert.assertEquals((Object)type, context.getCustomAttributes(context.getRootComponent()).get(attribute));
        context = new DesignContext();
        context.setCustomAttribute((Component)component, attribute, type);
        context.setShouldWriteDataDelegate(DeclarativeTestBaseBase.ALWAYS_WRITE_DATA);
        this.testWrite(component, design, context);
    }

    @Test
    public void dataWithCaptionGeneratorSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        AbstractSingleSelect component = (AbstractSingleSelect)this.getComponentClass().newInstance();
        Method setItemCaptionGenerator = this.getItemCaptionGeneratorMethod(component);
        if (setItemCaptionGenerator == null) {
            return;
        }
        String design = String.format("<%s>\n<option item='foo'>foo1</option>\n<option item='bar' selected>bar1</option><option item='foobar'>foobar1</option></%s>", this.getComponentTag(), this.getComponentTag());
        component.setItems(items);
        component.setValue((Object)"bar");
        ItemCaptionGenerator & Serializable generator = (ItemCaptionGenerator & Serializable)item -> item + "1";
        setItemCaptionGenerator.invoke((Object)component, generator);
        this.testRead(design, component);
        this.testWrite(design, component, true);
    }

    @Override
    @Test
    public void readOnlySelection() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        AbstractSingleSelect component = (AbstractSingleSelect)this.getComponentClass().newInstance();
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String design = String.format("<%s readonly>\n<option item='foo'>foo</option>\n<option item='bar'>bar</option><option item='foobar'>foobar</option>", this.getComponentTag(), this.getComponentTag());
        component.setItems(items);
        component.setReadOnly(true);
        this.testRead(design, component);
        this.testWrite(design, component, true);
    }

    private Method getItemCaptionGeneratorMethod(T component) throws IllegalAccessException, InvocationTargetException {
        try {
            return component.getClass().getMethod("setItemCaptionGenerator", ItemCaptionGenerator.class);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }
}

