/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractorderedlayout;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.tests.server.component.DeclarativeMarginTestBase;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public class AbstractOrderedLayoutDeclarativeTest
extends DeclarativeMarginTestBase<AbstractOrderedLayout> {
    private List<String> defaultAlignments = Arrays.asList(":top", ":left");

    @Test
    public void testMarginsVertical() {
        this.testMargins("vaadin-vertical-layout", new MarginInfo(true));
    }

    @Test
    public void testMarginsHorizontal() {
        this.testMargins("vaadin-horizontal-layout", new MarginInfo(false));
    }

    @Test
    public void testMarginsForm() {
        this.testMargins("vaadin-form-layout", new MarginInfo(true, false));
    }

    @Test
    public void testSpacingVertical() {
        this.testSpacing("vaadin-vertical-layout", true);
    }

    @Test
    public void testSpacingHorizontal() {
        this.testSpacing("vaadin-horizontal-layout", true);
    }

    @Test
    public void testSpacingForm() {
        this.testSpacing("vaadin-form-layout", true);
    }

    @Test
    public void testExpandRatio() {
        String design = this.getDesign(1.0f, new String[0]);
        AbstractOrderedLayout layout = this.getLayout(1.0f, null);
        this.testRead(design, layout);
        this.testWrite(design, layout);
        design = this.getDesign(0.25f, new String[0]);
        layout = this.getLayout(0.25f, null);
        this.testRead(design, layout);
        this.testWrite(design, layout);
    }

    @Test
    public void testAlignment() {
        String design = this.getDesign(0.0f, ":top", ":left");
        AbstractOrderedLayout layout = this.getLayout(0.0f, Alignment.TOP_LEFT);
        this.testRead(design, layout);
        this.testWrite(design, layout);
        design = this.getDesign(0.0f, ":middle", ":center");
        layout = this.getLayout(0.0f, Alignment.MIDDLE_CENTER);
        this.testRead(design, layout);
        this.testWrite(design, layout);
        design = this.getDesign(0.0f, ":bottom", ":right");
        layout = this.getLayout(0.0f, Alignment.BOTTOM_RIGHT);
        this.testRead(design, layout);
        this.testWrite(design, layout);
    }

    private String getDesign(float expandRatio, String ... alignments) {
        String ratioString;
        String result = "<vaadin-vertical-layout caption=test-layout>";
        result = result + "<vaadin-label caption=test-label ";
        String string = ratioString = expandRatio == 1.0f ? null : String.valueOf(expandRatio);
        if (expandRatio != 0.0f) {
            result = ratioString == null ? result + ":expand" : result + ":expand=" + ratioString;
        }
        for (String alignment : alignments) {
            if (this.defaultAlignments.contains(alignment)) continue;
            result = result + " " + alignment;
        }
        result = result + "></vaadin-label><vaadin-button ";
        if (expandRatio != 0.0f) {
            result = ratioString == null ? result + ":expand" : result + ":expand=" + ratioString;
        }
        for (String alignment : alignments) {
            if (this.defaultAlignments.contains(alignment)) continue;
            result = result + " " + alignment;
        }
        result = result + "></vaadin-button></vaadin-vertical-layout>";
        return result;
    }

    private AbstractOrderedLayout getLayout(float expandRatio, Alignment alignment) {
        VerticalLayout layout = new VerticalLayout();
        layout.setCaption("test-layout");
        Label l = new Label();
        l.setCaption("test-label");
        l.setContentMode(ContentMode.HTML);
        layout.addComponent((Component)l);
        layout.setExpandRatio((Component)l, expandRatio);
        Button b = new Button();
        b.setCaptionAsHtml(true);
        layout.addComponent((Component)b);
        layout.setExpandRatio((Component)b, expandRatio);
        if (alignment != null) {
            layout.setComponentAlignment((Component)l, alignment);
            layout.setComponentAlignment((Component)b, alignment);
        }
        return layout;
    }
}

