/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractcomponent;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.ErrorLevel;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractComponentDeclarativeTest
extends DeclarativeTestBase<AbstractComponent> {
    private AbstractComponent component;

    @Before
    public void setUp() {
        Label l = new Label();
        l.setContentMode(ContentMode.HTML);
        this.component = l;
    }

    @Test
    public void testEmptyDesign() {
        String design = "<vaadin-label>";
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testProperties() {
        String design = "<vaadin-label id=\"testId\" primary-style-name=\"test-style\" caption=\"test-caption\" locale=\"fi_FI\" description=\"test-description\" error=\"<div>test-error</div>\" />";
        this.component.setId("testId");
        this.component.setPrimaryStyleName("test-style");
        this.component.setCaption("test-caption");
        this.component.setLocale(new Locale("fi", "FI"));
        this.component.setDescription("test-description");
        this.component.setComponentError((ErrorMessage)new UserError("<div>test-error</div>", AbstractErrorMessage.ContentMode.HTML, ErrorLevel.ERROR));
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testReadEnabled() {
        String[] design = new String[]{"<vaadin-label/>", "<vaadin-label enabled=\"false\"/>", "<vaadin-label enabled=\"true\"/>", "<vaadin-label enabled />"};
        boolean[] enabled = new boolean[]{true, false, true, true};
        for (int i = 0; i < design.length; ++i) {
            this.component = (AbstractComponent)Design.read((InputStream)new ByteArrayInputStream(design[i].getBytes(StandardCharsets.UTF_8)));
            Assert.assertEquals((String)("component " + i + ":"), (Object)enabled[i], (Object)this.component.isEnabled());
        }
    }

    @Test
    public void testExternalIcon() {
        String design = "<vaadin-label icon=\"http://example.com/example.gif\"/>";
        this.component.setIcon((Resource)new ExternalResource("http://example.com/example.gif"));
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testThemeIcon() {
        String design = "<vaadin-label icon=\"theme://example.gif\"/>";
        this.component.setIcon((Resource)new ThemeResource("example.gif"));
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testFileResourceIcon() {
        String design = "<vaadin-label icon=\"img/example.gif\"/>";
        this.component.setIcon((Resource)new FileResource(new File("img/example.gif")));
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testWidthAndHeight() {
        String design = "<vaadin-label width=\"70%\" height=\"12px\"/>";
        this.component.setWidth("70%");
        this.component.setHeight("12px");
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testSizeFull() {
        String design = "<vaadin-label size-full />";
        this.component.setSizeFull();
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testSizeAuto() {
        this.component = new Panel();
        String design = "<vaadin-panel size-auto />";
        this.component.setSizeUndefined();
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testHeightFull() {
        String design = "<vaadin-label height-full width=\"20px\"/>";
        this.component.setHeight("100%");
        this.component.setWidth("20px");
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testHeightAuto() {
        String design = "<vaadin-horizontal-split-panel height-auto width=\"20px\" >";
        HorizontalSplitPanel component = new HorizontalSplitPanel();
        component.setHeight(null);
        component.setWidth("20px");
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void testWidthFull() {
        String design = "<vaadin-button width-full height=\"20px\">Foo</vaadin-button>";
        Button component = new Button();
        component.setCaptionAsHtml(true);
        component.setCaption("Foo");
        component.setHeight("20px");
        component.setWidth("100%");
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void testWidthAuto() {
        this.component = new Panel();
        String design = "<vaadin-panel height=\"20px\"/ width-auto />";
        this.component.setCaptionAsHtml(false);
        this.component.setHeight("20px");
        this.component.setWidth(null);
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testResponsive() {
        String design = "<vaadin-label responsive />";
        Responsive.makeResponsive((Component[])new Component[]{this.component});
        this.testRead(design, this.component);
        this.testWrite(design, this.component);
    }

    @Test
    public void testResponsiveFalse() {
        String design = "<vaadin-label responsive =\"false\"/>";
        this.testRead(design, this.component);
    }

    @Test
    public void testReadAlreadyResponsive() {
        Label component = new Label();
        Responsive.makeResponsive((Component[])new Component[]{component});
        Element design = this.createDesign(true);
        component.readDesign(design, new DesignContext());
        Assert.assertEquals((String)"Component should have only one extension", (long)1L, (long)component.getExtensions().size());
    }

    @Test
    public void testUnknownProperties() {
        String design = "<vaadin-label foo=\"bar\"/>";
        DesignContext context = this.readAndReturnContext(design);
        Label label = (Label)context.getRootComponent();
        Assert.assertTrue((String)"Custom attribute was preserved in custom attributes", (boolean)context.getCustomAttributes((Component)label).containsKey("foo"));
        this.testWrite(label, design, context);
    }

    private Element createDesign(boolean responsive) {
        Attributes attributes = new Attributes();
        attributes.put("responsive", responsive);
        Element node = new Element(Tag.valueOf((String)"vaadin-label"), "", attributes);
        return node;
    }
}

