/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.VaadinClasses;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentRootSetter;
import com.vaadin.ui.Composite;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StateGetDoesNotMarkDirtyTest {
    private final Set<String> excludedMethods = new HashSet<String>();

    @Before
    public void setUp() {
        this.excludedMethods.add(Label.class.getName() + "getDataProviderValue");
        this.excludedMethods.add("getConnectorId");
        this.excludedMethods.add("getContent");
        this.excludedMethods.add("com.vaadin.ui.Grid:getSelectAllCheckBoxVisible");
        this.excludedMethods.add("com.vaadin.ui.TreeGrid:getDataProvider");
    }

    @Test
    public void testGetDoesntMarkStateDirty() throws Exception {
        int count = 0;
        for (Class<? extends Component> clazz : VaadinClasses.getComponents()) {
            Component newInstance;
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || (newInstance = this.construct(clazz)) == null) continue;
            ++count;
            this.prepareMockUI(newInstance);
            HashSet<Method> methods = new HashSet<Method>();
            methods.addAll(Arrays.asList(clazz.getMethods()));
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            for (Method method : methods) {
                try {
                    if (!method.getName().startsWith("is") && !method.getName().startsWith("get") || method.getName().startsWith("getState") || method.getParameterTypes().length > 0 || this.excludedMethods.contains(clazz.getName() + ":" + method.getName()) || this.excludedMethods.contains(method.getName())) continue;
                    method.setAccessible(true);
                    try {
                        method.invoke((Object)newInstance, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof UnsupportedOperationException) continue;
                        throw e;
                    }
                }
                catch (Exception e) {
                    System.err.println("problem with method " + clazz.getName() + "# " + method.getName());
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    private void prepareMockUI(Component newInstance) {
        UI ui = this.mockUI();
        ConnectorTracker connectorTracker = ui.getConnectorTracker();
        ((ConnectorTracker)Mockito.doThrow((Throwable)new RuntimeException("getState(true) called in getter")).when((Object)connectorTracker)).markDirty((ClientConnector)newInstance);
        newInstance.setParent(null);
        newInstance.setParent((HasComponents)ui);
    }

    private UI mockUI() {
        UI ui = (UI)Mockito.mock(UI.class);
        Mockito.when((Object)ui.getLocale()).thenReturn((Object)Locale.ENGLISH);
        ConnectorTracker connectorTracker = (ConnectorTracker)Mockito.mock(ConnectorTracker.class);
        Mockito.when((Object)ui.getConnectorTracker()).thenReturn((Object)connectorTracker);
        return ui;
    }

    private Component construct(Class<? extends Component> clazz) {
        try {
            Constructor<? extends Component> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            Component component = declaredConstructor.newInstance(new Object[0]);
            if (component instanceof UI) {
                return component;
            }
            if (component.getClass().equals(Composite.class)) {
                ComponentRootSetter.setRoot((Component)component, (Component)new Label());
            }
            this.emulateAttach(component);
            return component;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void emulateAttach(Component component) {
        UI ui = this.mockUI();
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)session.hasLock()).thenReturn((Object)true);
        Mockito.when((Object)ui.getSession()).thenReturn((Object)session);
        component.setParent((HasComponents)ui);
        component.attach();
    }
}

