/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadEmptyDesignTest {
    InputStream is;

    @Before
    public void setUp() {
        String html = this.createDesign().toString();
        this.is = new ByteArrayInputStream(html.getBytes());
    }

    @Test
    public void testReadComponent() {
        Component root = Design.read((InputStream)this.is);
        Assert.assertNull((String)"The root component should be null.", (Object)root);
    }

    @Test
    public void testReadContext() {
        DesignContext ctx = Design.read((InputStream)this.is, null);
        Assert.assertNotNull((String)"The design context should not be null.", (Object)ctx);
        Assert.assertNull((String)"The root component should be null.", (Object)ctx.getRootComponent());
    }

    @Test
    public void testReadContextWithRootParameter() {
        try {
            VerticalLayout rootComponent = new VerticalLayout();
            DesignContext ctx = Design.read((InputStream)this.is, (Component)rootComponent);
            Assert.fail((String)"Reading a design with no elements should fail when a non-null root Component is specified.");
        }
        catch (DesignException designException) {
            // empty catch block
        }
    }

    private Document createDesign() {
        Document doc = new Document("");
        DocumentType docType = new DocumentType("html", "", "");
        doc.appendChild((Node)docType);
        Element html = doc.createElement("html");
        doc.appendChild((Node)html);
        html.appendChild((Node)doc.createElement("head"));
        html.appendChild((Node)doc.createElement("body"));
        return doc;
    }
}

