/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.LabelState;
import com.vaadin.ui.Label;
import org.junit.Assert;
import org.junit.Test;

public class ComponentSizeParseTest {
    @Test
    public void testAllTheUnit() {
        this.testUnit("10.0px", 10, Sizeable.Unit.PIXELS);
        this.testUnit("10.0pt", 10, Sizeable.Unit.POINTS);
        this.testUnit("10.0pc", 10, Sizeable.Unit.PICAS);
        this.testUnit("10.0em", 10, Sizeable.Unit.EM);
        this.testUnit("10.0rem", 10, Sizeable.Unit.REM);
        this.testUnit("10.0mm", 10, Sizeable.Unit.MM);
        this.testUnit("10.0cm", 10, Sizeable.Unit.CM);
        this.testUnit("10.0in", 10, Sizeable.Unit.INCH);
        this.testUnit("10.0%", 10, Sizeable.Unit.PERCENTAGE);
    }

    private void testUnit(String string, int amout, Sizeable.Unit unit) {
        LabelWithPublicState label = new LabelWithPublicState();
        label.setHeight(string);
        Assert.assertEquals((float)amout, (float)label.getHeight(), (float)0.0f);
        Assert.assertEquals((Object)unit, (Object)label.getHeightUnits());
        label = new LabelWithPublicState();
        label.setHeight(10.0f, unit);
        label.beforeClientResponse(true);
        Assert.assertEquals((Object)string, (Object)label.getState().height);
    }

    private final class LabelWithPublicState
    extends Label {
        private LabelWithPublicState() {
        }

        protected LabelState getState() {
            return super.getState();
        }
    }
}

