/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.shared.Registration;
import com.vaadin.tests.VaadinClasses;
import com.vaadin.ui.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.easymock.EasyMock;
import org.junit.Assert;

public abstract class AbstractListenerMethodsTestBase {
    public static void main(String[] args) {
        AbstractListenerMethodsTestBase.findAllListenerMethods();
    }

    private static void findAllListenerMethods() {
        HashSet<Class<? extends Object>> classes = new HashSet<Class<? extends Object>>();
        Iterator<Class<Object>> iterator = VaadinClasses.getAllServerSideClasses().iterator();
        while (iterator.hasNext()) {
            for (Class<? extends Object> c = iterator.next(); c != null && c.getName().startsWith("com.vaadin."); c = c.getSuperclass()) {
                classes.add(c);
            }
        }
        for (Class<? extends Object> c : classes) {
            boolean found = false;
            for (Method m : c.getDeclaredMethods()) {
                String methodName = m.getName();
                if (!methodName.startsWith("add") || !methodName.endsWith("Listener") || "addListener".equals(methodName) || m.getParameterTypes().length != 1) continue;
                String packageName = "com.vaadin.tests.server";
                if (Component.class.isAssignableFrom(c)) {
                    packageName = packageName + ".component." + c.getSimpleName().toLowerCase(Locale.ROOT);
                    continue;
                }
                if (!found) {
                    found = true;
                    System.out.println("package " + packageName + ";");
                    System.out.println("import " + AbstractListenerMethodsTestBase.class.getName() + ";");
                    System.out.println("import " + c.getName() + ";");
                    System.out.println("public class " + c.getSimpleName() + "Listeners extends " + AbstractListenerMethodsTestBase.class.getSimpleName() + " {");
                }
                String listenerClassName = m.getParameterTypes()[0].getSimpleName();
                String eventClassName = listenerClassName.replaceFirst("Listener$", "Event");
                System.out.println("public void test" + listenerClassName + "() throws Exception {");
                System.out.println("    testListener(" + c.getSimpleName() + ".class, " + eventClassName + ".class, " + listenerClassName + ".class);");
                System.out.println("}");
            }
            if (!found) continue;
            System.out.println("}");
            System.out.println();
        }
    }

    protected void testListenerAddGetRemove(Class<?> testClass, Class<?> eventClass, Class<?> listenerClass) throws Exception {
        Object c = testClass.newInstance();
        this.testListenerAddGetRemove(testClass, eventClass, listenerClass, c);
    }

    protected void testListenerAddGetRemove(Class<?> cls, Class<?> eventClass, Class<?> listenerClass, Object c) throws Exception {
        Object mockListener1 = EasyMock.createMock(listenerClass);
        Object mockListener2 = EasyMock.createMock(listenerClass);
        this.verifyListeners(c, eventClass, new Object[0]);
        Registration listener1Registration = this.addListener(c, mockListener1, listenerClass);
        this.verifyListeners(c, eventClass, mockListener1);
        Registration listener2Registration = this.addListener(c, mockListener2, listenerClass);
        this.verifyListeners(c, eventClass, mockListener1, mockListener2);
        if (eventClass.getSuperclass() != null) {
            this.verifyListeners(c, eventClass.getSuperclass(), mockListener1, mockListener2);
        }
        listener1Registration.remove();
        this.verifyListeners(c, eventClass, mockListener2);
        listener2Registration.remove();
        this.verifyListeners(c, eventClass, new Object[0]);
    }

    private Registration addListener(Object c, Object listener1, Class<?> listenerClass) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method = this.getAddListenerMethod(c.getClass(), listenerClass);
        return (Registration)method.invoke(c, listener1);
    }

    private Collection<?> getListeners(Object c, Class<?> eventType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method = this.getGetListenersMethod(c.getClass());
        return (Collection)method.invoke(c, eventType);
    }

    private Method getGetListenersMethod(Class<? extends Object> cls) throws SecurityException, NoSuchMethodException {
        return cls.getMethod("getListeners", Class.class);
    }

    private Method getAddListenerMethod(Class<?> cls, Class<?> listenerClass) throws SecurityException, NoSuchMethodException {
        Method addListenerMethod = cls.getMethod("add" + listenerClass.getSimpleName(), listenerClass);
        if (addListenerMethod.getReturnType() != Registration.class) {
            throw new NoSuchMethodException(cls.getSimpleName() + ".add" + listenerClass.getSimpleName() + " has wrong return type, expected Registration");
        }
        return addListenerMethod;
    }

    private void verifyListeners(Object c, Class<?> eventClass, Object ... expectedListeners) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Collection<?> registeredListeners = this.getListeners(c, eventClass);
        Assert.assertEquals((String)"Number of listeners", (long)expectedListeners.length, (long)registeredListeners.size());
        Assert.assertArrayEquals((Object[])expectedListeners, (Object[])registeredListeners.toArray());
    }
}

