/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.clientconnector;

import com.vaadin.event.ConnectorEvent;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IMocksControl;
import org.junit.Before;
import org.junit.Test;

public class AttachDetachListenersTest {
    private IMocksControl control;
    private VaadinSession session;
    private UI ui;
    private Layout content;
    private Component component;
    ClientConnector.AttachListener attachListener;
    ClientConnector.DetachListener detachListener;

    @Before
    public void setUp() {
        this.control = EasyMock.createStrictControl();
        this.session = new AlwaysLockedVaadinSession((VaadinService)this.control.createMock(VaadinService.class));
        this.ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        this.content = new CssLayout();
        this.component = new Label();
        this.attachListener = (ClientConnector.AttachListener)this.control.createMock(ClientConnector.AttachListener.class);
        this.detachListener = (ClientConnector.DetachListener)this.control.createMock(ClientConnector.DetachListener.class);
    }

    @Test
    public void attachListeners_setSessionLast() {
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.component)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.content)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.ui)));
        this.control.replay();
        this.ui.addAttachListener(this.attachListener);
        this.content.addAttachListener(this.attachListener);
        this.component.addAttachListener(this.attachListener);
        this.ui.setContent((Component)this.content);
        this.content.addComponent(this.component);
        this.ui.setSession(this.session);
        this.control.verify();
    }

    @Test
    public void attachListeners_setSessionFirst() {
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.ui)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.content)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.component)));
        this.control.replay();
        this.ui.addAttachListener(this.attachListener);
        this.content.addAttachListener(this.attachListener);
        this.component.addAttachListener(this.attachListener);
        this.ui.setSession(this.session);
        this.ui.setContent((Component)this.content);
        this.content.addComponent(this.component);
        this.control.verify();
    }

    @Test
    public void attachListeners_setSessionBetween() {
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.content)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.ui)));
        this.attachListener.attach(AttachDetachListenersTest.eventEquals(new ClientConnector.AttachEvent((ClientConnector)this.component)));
        this.control.replay();
        this.ui.addAttachListener(this.attachListener);
        this.content.addAttachListener(this.attachListener);
        this.component.addAttachListener(this.attachListener);
        this.ui.setContent((Component)this.content);
        this.ui.setSession(this.session);
        this.content.addComponent(this.component);
        this.control.verify();
    }

    @Test
    public void detachListeners_setSessionNull() {
        this.setupDetachListeners();
        this.ui.setContent((Component)this.content);
        this.content.addComponent(this.component);
        this.ui.setSession(null);
        this.control.verify();
    }

    @Test
    public void detachListeners_removeComponent() {
        this.setupDetachListeners();
        this.ui.setContent((Component)this.content);
        this.content.addComponent(this.component);
        this.content.removeAllComponents();
        this.ui.setSession(null);
        this.control.verify();
    }

    @Test
    public void detachListeners_setContentNull() {
        this.setupDetachListeners();
        this.ui.setContent((Component)this.content);
        this.content.addComponent(this.component);
        this.ui.setContent(null);
        this.ui.setSession(null);
        this.control.verify();
    }

    public static <E extends ConnectorEvent> E eventEquals(E expected) {
        EasyMock.reportMatcher(new EventEquals<E>(expected));
        return null;
    }

    private void setupDetachListeners() {
        this.detachListener.detach(AttachDetachListenersTest.eventEquals(new ClientConnector.DetachEvent((ClientConnector)this.component)));
        this.detachListener.detach(AttachDetachListenersTest.eventEquals(new ClientConnector.DetachEvent((ClientConnector)this.content)));
        this.detachListener.detach(AttachDetachListenersTest.eventEquals(new ClientConnector.DetachEvent((ClientConnector)this.ui)));
        this.control.replay();
        this.ui.addDetachListener(this.detachListener);
        this.content.addDetachListener(this.detachListener);
        this.component.addDetachListener(this.detachListener);
        this.ui.setSession(this.session);
    }

    public static class EventEquals<E extends ConnectorEvent>
    implements IArgumentMatcher {
        private final E expected;

        public EventEquals(E expected) {
            this.expected = expected;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("EventEquals(");
            buffer.append("expected ").append(this.expected.getClass().getSimpleName()).append(" with connector ").append(this.expected.getConnector());
            buffer.append(')');
        }

        public boolean matches(Object argument) {
            return this.expected.getClass().isInstance(argument) && ((ConnectorEvent)argument).getConnector() == this.expected.getConnector();
        }
    }
}

