/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.communication.FileUploadHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.Test;

public class SimpleMultiPartInputStreamTest {
    protected void checkBoundaryDetection(byte[] input, String boundary, byte[] expected) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        try (FileUploadHandler.SimpleMultiPartInputStream smpis = new FileUploadHandler.SimpleMultiPartInputStream((InputStream)bais, boundary);){
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            try {
                int outbyte;
                while ((outbyte = smpis.read()) != -1) {
                    resultStream.write(outbyte);
                }
            }
            catch (IOException e) {
                throw new IOException(e.getMessage() + "; expected " + new String(expected) + " but got " + resultStream.toString());
            }
            if (!Arrays.equals(expected, resultStream.toByteArray())) {
                throw new Exception("Mismatch: expected " + new String(expected) + " but got " + resultStream.toString());
            }
        }
    }

    protected void checkBoundaryDetection(String input, String boundary, String expected) throws Exception {
        this.checkBoundaryDetection(input.getBytes(), boundary, expected.getBytes());
    }

    @Test
    public void testSingleByteBoundaryAtEnd() throws Exception {
        this.checkBoundaryDetection("xyz123" + SimpleMultiPartInputStreamTest.getFullBoundary("a"), "a", "xyz123");
    }

    @Test
    public void testSingleByteBoundaryInMiddle() throws Exception {
        this.checkBoundaryDetection("xyz" + SimpleMultiPartInputStreamTest.getFullBoundary("a") + "123", "a", "xyz");
    }

    @Test
    public void testCorrectBoundaryAtEnd() throws Exception {
        this.checkBoundaryDetection("xyz123" + SimpleMultiPartInputStreamTest.getFullBoundary("abc"), "abc", "xyz123");
    }

    @Test
    public void testCorrectBoundaryNearEnd() throws Exception {
        this.checkBoundaryDetection("xyz123" + SimpleMultiPartInputStreamTest.getFullBoundary("abc") + "de", "abc", "xyz123");
    }

    @Test
    public void testCorrectBoundaryAtBeginning() throws Exception {
        this.checkBoundaryDetection(SimpleMultiPartInputStreamTest.getFullBoundary("abc") + "xyz123", "abc", "");
    }

    @Test
    public void testRepeatingCharacterBoundary() throws Exception {
        this.checkBoundaryDetection(SimpleMultiPartInputStreamTest.getFullBoundary("aa") + "xyz123", "aa", "");
        this.checkBoundaryDetection("axyz" + SimpleMultiPartInputStreamTest.getFullBoundary("aa") + "123", "aa", "axyz");
        this.checkBoundaryDetection("xyz123" + SimpleMultiPartInputStreamTest.getFullBoundary("aa"), "aa", "xyz123");
    }

    @Test
    public void testRepeatingStringBoundary() throws Exception {
        this.checkBoundaryDetection(SimpleMultiPartInputStreamTest.getFullBoundary("abab") + "xyz123", "abab", "");
        this.checkBoundaryDetection("abaxyz" + SimpleMultiPartInputStreamTest.getFullBoundary("abab") + "123", "abab", "abaxyz");
        this.checkBoundaryDetection("xyz123" + SimpleMultiPartInputStreamTest.getFullBoundary("abab"), "abab", "xyz123");
    }

    @Test
    public void testOverlappingBoundary() throws Exception {
        this.checkBoundaryDetection("abc" + SimpleMultiPartInputStreamTest.getFullBoundary("abcabd") + "xyz123", "abcabd", "abc");
        this.checkBoundaryDetection("xyzabc" + SimpleMultiPartInputStreamTest.getFullBoundary("abcabd") + "123", "abcabd", "xyzabc");
        this.checkBoundaryDetection("xyz123abc" + SimpleMultiPartInputStreamTest.getFullBoundary("abcabd"), "abcabd", "xyz123abc");
    }

    public static String getFullBoundary(String str) {
        return "\r\n--" + str + "--";
    }
}

