/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.DownloadStream;
import com.vaadin.server.FileResource;
import java.io.File;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class FileResourceTest {
    @Test(expected=IllegalArgumentException.class)
    public void nullFile() {
        new FileResource(null);
    }

    @Test(expected=RuntimeException.class)
    public void nonExistingFile() {
        new FileResource(new File("nonexisting")).getStream();
    }

    @Test
    public void bufferSize() throws URISyntaxException {
        File file = new File(this.getClass().getResource("../styles.scss").toURI());
        FileResource resource = new FileResource(file){

            public long getCacheTime() {
                return 5L;
            }
        };
        resource.setBufferSize(100);
        resource.setCacheTime(200L);
        DownloadStream downloadStream = resource.getStream();
        Assert.assertEquals((String)"DownloadStream buffer size must be same as resource buffer size", (long)resource.getBufferSize(), (long)downloadStream.getBufferSize());
        Assert.assertEquals((String)"DownloadStream cache time must be same as resource cache time", (long)resource.getCacheTime(), (long)downloadStream.getCacheTime());
    }
}

