/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.ServerRpcHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import elemental.json.JsonException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsrfTokenMissingTest {
    private VaadinServlet mockServlet;
    private MockDeploymentConfiguration mockDeploymentConfiguration;
    private VaadinServletService mockService;
    private VaadinSession mockSession;
    private VaadinServletRequest vaadinRequest;
    private TokenType tokenType;
    private String invalidToken;
    private static final Logger LOGGER = Logger.getLogger(CsrfTokenMissingTest.class.getName());

    @Before
    public void initMockStuff() throws ServiceException, ServletException {
        this.mockServlet = new VaadinServlet();
        this.mockServlet.init((ServletConfig)new MockServletConfig());
        this.mockDeploymentConfiguration = new MockDeploymentConfiguration();
        this.mockService = new VaadinServletService(this.mockServlet, (DeploymentConfiguration)this.mockDeploymentConfiguration);
        this.mockSession = new AlwaysLockedVaadinSession((VaadinService)this.mockService);
        this.vaadinRequest = new VaadinServletRequest((HttpServletRequest)EasyMock.createMock(HttpServletRequest.class), this.mockService);
    }

    public String getInvalidToken() {
        if (this.invalidToken == null) {
            this.invalidToken = UUID.randomUUID().toString().substring(1);
        }
        return this.invalidToken;
    }

    private String getValidToken() {
        return this.mockSession.getCsrfToken();
    }

    private String getPayload() {
        switch (this.tokenType) {
            case MISSING: {
                return this.getPayload(null);
            }
            case INVALID: {
                return this.getPayload(this.getInvalidToken());
            }
            case VALID: {
                return this.getPayload(this.getValidToken());
            }
        }
        return null;
    }

    private String getPayload(String token) {
        return "{" + (token != null ? "\"csrfToken\":\"" + token + "\", " : "") + "\"rpc\":[[\"0\",\"com.vaadin.shared.ui.ui.UIServerRpc\",\"resize\",[\"449\",\"1155\",\"1155\",\"449\"]],[\"4\",\"com.vaadin.shared.ui.button.ButtonServerRpc\",\"click\",[{\"clientY\":\"53\", \"clientX\":\"79\", \"shiftKey\":false, \"button\":\"LEFT\", \"ctrlKey\":false, \"type\":\"1\", \"metaKey\":false, \"altKey\":false, \"relativeY\":\"17\", \"relativeX\":\"61\"}]]], \"syncId\":1}";
    }

    private void initTest(boolean enableSecurity, TokenType tokenType) {
        this.mockDeploymentConfiguration.setXsrfProtectionEnabled(enableSecurity);
        this.tokenType = tokenType;
    }

    private ServerRpcHandler.RpcRequest createRequest() {
        try {
            return new ServerRpcHandler.RpcRequest(this.getPayload(), (VaadinRequest)this.vaadinRequest);
        }
        catch (JsonException e) {
            LOGGER.log(Level.SEVERE, "", e);
            Assert.assertTrue((boolean)false);
            return null;
        }
    }

    private boolean isDefaultToken(ServerRpcHandler.RpcRequest rpcRequest) {
        return "init".equals(rpcRequest.getCsrfToken());
    }

    private boolean isInvalidToken(ServerRpcHandler.RpcRequest rpcRequest) {
        return this.getInvalidToken().equals(rpcRequest.getCsrfToken());
    }

    private boolean isValidToken(ServerRpcHandler.RpcRequest rpcRequest) {
        return this.getValidToken().equals(rpcRequest.getCsrfToken());
    }

    private boolean isRequestValid(ServerRpcHandler.RpcRequest rpcRequest) {
        return VaadinService.isCsrfTokenValid((VaadinSession)this.mockSession, (String)rpcRequest.getCsrfToken());
    }

    @Test
    public void securityOnAndNoToken() {
        this.initTest(true, TokenType.MISSING);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isDefaultToken(rpcRequest));
        Assert.assertFalse((boolean)this.isRequestValid(rpcRequest));
    }

    @Test
    public void securityOffAndNoToken() {
        this.initTest(false, TokenType.MISSING);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isDefaultToken(rpcRequest));
        Assert.assertTrue((boolean)this.isRequestValid(rpcRequest));
    }

    @Test
    public void securityOnAndInvalidToken() {
        this.initTest(true, TokenType.INVALID);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isInvalidToken(rpcRequest));
        Assert.assertFalse((boolean)this.isRequestValid(rpcRequest));
    }

    @Test
    public void securityOffAndInvalidToken() {
        this.initTest(false, TokenType.INVALID);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isInvalidToken(rpcRequest));
        Assert.assertTrue((boolean)this.isRequestValid(rpcRequest));
    }

    @Test
    public void securityOnAndValidToken() {
        this.initTest(true, TokenType.VALID);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isValidToken(rpcRequest));
        Assert.assertTrue((boolean)this.isRequestValid(rpcRequest));
    }

    @Test
    public void securityOffAndValidToken() {
        this.initTest(false, TokenType.VALID);
        ServerRpcHandler.RpcRequest rpcRequest = this.createRequest();
        Assert.assertTrue((boolean)this.isValidToken(rpcRequest));
        Assert.assertTrue((boolean)this.isRequestValid(rpcRequest));
    }

    static {
        LOGGER.setLevel(Level.ALL);
    }

    private static enum TokenType {
        MISSING,
        INVALID,
        VALID;

    }
}

