/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ClassesSerializableTest {
    private static final String JAR_PATTERN = ".*vaadin.*\\.jar";
    private static final String[] BASE_PACKAGES = new String[]{"com.vaadin"};
    private static final String[] EXCLUDED_PATTERNS = new String[]{"com\\.vaadin\\.open\\..*", "com\\.vaadin\\.pro\\.license.*", "com\\.vaadin\\.demo\\..*", "com\\.vaadin\\.external\\.org\\.apache\\.commons\\.fileupload\\..*", "com\\.vaadin\\.launcher\\..*", "com\\.vaadin\\.client\\..*", "com\\.vaadin\\.server\\.widgetsetutils\\..*", "com\\.vaadin\\.server\\.themeutils\\..*", "com\\.vaadin\\.tests\\..*", "com\\.vaadin\\.tools\\..*", "com\\.vaadin\\.ui\\.themes\\..*", "com\\.vaadin\\.event\\.FieldEvents", "com\\.vaadin\\.util\\.FileTypeResolver", "com\\.vaadin\\.event\\.LayoutEvents", "com\\.vaadin\\.event\\.MouseEvents", "com\\.vaadin\\.event\\.UIEvents", "com\\.vaadin\\.server\\.VaadinPortlet", "com\\.vaadin\\.server\\.MockServletConfig", "com\\.vaadin\\.server\\.MockServletContext", "com\\.vaadin\\.server\\.MockVaadinServletService", "com\\.vaadin\\.server\\.Constants", "com\\.vaadin\\.server\\.VaadinServiceClassLoaderUtil", "com\\.vaadin\\.server\\.VaadinServiceClassLoaderUtil\\$GetClassLoaderPrivilegedAction", "com\\.vaadin\\.server\\.communication\\.FileUploadHandler\\$SimpleMultiPartInputStream", "com\\.vaadin\\.server\\.communication\\.PushRequestHandler.*", "com\\.vaadin\\.server\\.communication\\.PushHandler.*", "com\\.vaadin\\.server\\.communication\\.DateSerializer", "com\\.vaadin\\.server\\.communication\\.JSONSerializer", "com\\.vaadin\\.ui\\.declarative\\.DesignContext", "com\\.vaadin\\.v7\\.util\\.SerializerHelper", "com\\.vaadin\\.server\\.LegacyCommunicationManager.*", "com\\.vaadin\\.util\\.EncodeUtil.*", "com\\.vaadin\\.util\\.ReflectTools.*", "com\\.vaadin\\.data\\.provider\\.InMemoryDataProviderHelpers", "com\\.vaadin\\.data\\.provider\\.HierarchyMapper\\$TreeLevelQuery", "com\\.vaadin\\.data\\.util\\.ReflectTools.*", "com\\.vaadin\\.data\\.util\\.JsonUtil.*", "com\\.vaadin\\.data\\.util\\.BeanUtil.*", "com\\.vaadin\\.data\\.validator\\.BeanValidator\\$1", "com\\.vaadin\\.sass.*", "com\\.vaadin\\.testbench.*", "com\\.vaadin\\.util\\.CurrentInstance\\$1", "com\\.vaadin\\.server\\.AbstractClientConnector\\$1", "com\\.vaadin\\.server\\.AbstractClientConnector\\$1\\$1", "com\\.vaadin\\.server\\.JsonCodec\\$1", "com\\.vaadin\\.server\\.communication\\.PushConnection", "com\\.vaadin\\.server\\.communication\\.AtmospherePushConnection.*", "com\\.vaadin\\.ui\\.components\\.colorpicker\\.ColorUtil", "com\\.vaadin\\.util\\.ConnectorHelper", "com\\.vaadin\\.server\\.VaadinSession\\$FutureAccess", "com\\.vaadin\\.external\\..*", "com\\.vaadin\\.util\\.WeakValueMap.*", "com\\.vaadin\\.themes\\.valoutil\\.BodyStyleName", "com\\.vaadin\\.server\\.communication\\.JSR356WebsocketInitializer.*", "com\\.vaadin\\.screenshotbrowser\\.ScreenshotBrowser.*", "com\\.vaadin\\.osgi.*", "com\\.vaadin\\.server\\.osgi.*", "com\\.vaadin\\.v7\\.ui\\.themes\\.BaseTheme", "com\\.vaadin\\.v7\\.ui\\.themes\\.ChameleonTheme", "com\\.vaadin\\.v7\\.ui\\.themes\\.Reindeer", "com\\.vaadin\\.v7\\.ui\\.themes\\.Runo", "com\\.vaadin\\.v7\\.tests\\.VaadinClasses", "com\\.vaadin\\.v7\\.event\\.FieldEvents", "com\\.vaadin\\.v7\\.data\\.util.BeanItemContainerGenerator.*", "com\\.vaadin\\.v7\\.data\\.util\\.sqlcontainer\\.connection\\.MockInitialContextFactory", "com\\.vaadin\\.v7\\.data\\.util\\.sqlcontainer\\.DataGenerator", "com\\.vaadin\\.v7\\.data\\.util\\.sqlcontainer\\.FreeformQueryUtil"};

    @Test
    public void testClassesSerializable() throws Exception {
        List<String> rawClasspathEntries = ClassesSerializableTest.getRawClasspathEntries();
        ArrayList<String> classes = new ArrayList<String>();
        for (String location : rawClasspathEntries) {
            classes.addAll(this.findServerClasses(location));
        }
        ArrayList<Field> nonSerializableFunctionFields = new ArrayList<Field>();
        ArrayList nonSerializableClasses = new ArrayList();
        for (String className : classes) {
            Class<?> iface;
            Class<?> cls = Class.forName(className);
            if (this.isTestClass(cls)) continue;
            Stream.of(cls.getDeclaredFields()).filter(field -> ClassesSerializableTest.isFunctionalType(field.getGenericType())).forEach(nonSerializableFunctionFields::add);
            if (cls.isAnnotation() || cls.isSynthetic()) continue;
            if (!cls.isInterface() && !Modifier.isAbstract(cls.getModifiers())) {
                this.serializeAndDeserialize(cls);
            }
            if (Serializable.class.isAssignableFrom(cls) || cls.getSuperclass() == Object.class && cls.getInterfaces().length == 1 && ((iface = cls.getInterfaces()[0]) == Runnable.class || iface == Comparator.class)) continue;
            nonSerializableClasses.add(cls);
        }
        if (!nonSerializableClasses.isEmpty()) {
            this.failSerializableClasses(nonSerializableClasses);
        }
        if (!nonSerializableFunctionFields.isEmpty()) {
            this.failSerializableFields(nonSerializableFunctionFields);
        }
    }

    private void serializeAndDeserialize(Class<?> clazz) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Optional<Constructor> defaultCtor = Stream.of(clazz.getDeclaredConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst();
        if (!defaultCtor.isPresent()) {
            return;
        }
        defaultCtor.get().setAccessible(true);
        Object instance = defaultCtor.get().newInstance(new Object[0]);
        ClassesSerializableTest.serializeAndDeserialize(instance);
    }

    public static <T> T serializeAndDeserialize(T instance) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(instance);
        byte[] data = bs.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Object readObject = in.readObject();
        return (T)readObject;
    }

    private void failSerializableFields(List<Field> nonSerializableFunctionFields) {
        String nonSerializableString = nonSerializableFunctionFields.stream().map(field -> String.format("%s.%s", field.getDeclaringClass().getName(), field.getName())).collect(Collectors.joining(", "));
        Assert.fail((String)("Fields with functional types that are not serializable: " + nonSerializableString));
    }

    private void failSerializableClasses(List<Class<?>> nonSerializableClasses) {
        String nonSerializableString = "";
        for (Class<?> c : nonSerializableClasses) {
            nonSerializableString = nonSerializableString + ", " + c.getName();
            if (!c.isAnonymousClass()) continue;
            nonSerializableString = nonSerializableString + "(super: ";
            nonSerializableString = nonSerializableString + c.getSuperclass().getName();
            nonSerializableString = nonSerializableString + ", interfaces: ";
            for (Class<?> i : c.getInterfaces()) {
                nonSerializableString = nonSerializableString + i.getName();
                nonSerializableString = nonSerializableString + ",";
            }
            nonSerializableString = nonSerializableString + ")";
        }
        Assert.fail((String)("Serializable not implemented by the following classes and interfaces: " + nonSerializableString));
    }

    private static boolean isFunctionalType(Type type) {
        return type.getTypeName().contains("java.util.function");
    }

    private boolean isTestClass(Class<?> cls) {
        if (cls.getEnclosingClass() != null && this.isTestClass(cls.getEnclosingClass())) {
            return true;
        }
        for (Method method : cls.getMethods()) {
            if (!method.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }

    private static final List<String> getRawClasspathEntries() {
        ArrayList<String> locations = new ArrayList<String>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        String[] split = classpath.split(pathSep);
        locations.addAll(Arrays.asList(split));
        return locations;
    }

    private List<String> findServerClasses(String classpathEntry) throws IOException {
        Collection<Object> classes = new ArrayList();
        File file = new File(classpathEntry);
        if (file.isDirectory()) {
            classes = ClassesSerializableTest.findClassesInDirectory(null, file);
        } else if (file.getName().matches(JAR_PATTERN)) {
            classes = this.findClassesInJar(file);
        } else {
            System.out.println("Ignoring " + classpathEntry);
            return Collections.emptyList();
        }
        ArrayList<String> filteredClasses = new ArrayList<String>();
        for (String string : classes) {
            boolean ok = false;
            for (String basePackage : BASE_PACKAGES) {
                if (!string.startsWith(basePackage + ".")) continue;
                ok = true;
                break;
            }
            for (String excludedPrefix : EXCLUDED_PATTERNS) {
                if (!string.matches(excludedPrefix)) continue;
                ok = false;
                break;
            }
            if (string.contains("Test")) {
                ok = false;
            }
            if (!ok) continue;
            filteredClasses.add(string);
        }
        return filteredClasses;
    }

    private Collection<String> findClassesInJar(File file) throws IOException {
        ArrayList<String> classes = new ArrayList<String>();
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String nameWithoutExtension = entry.getName().replaceAll("\\.class", "");
                String className = nameWithoutExtension.replace('/', '.');
                classes.add(className);
            }
        }
        return classes;
    }

    private static final Collection<String> findClassesInDirectory(String parentPackage, File parent) {
        File[] files;
        if (parent.isHidden() || parent.getPath().contains(File.separator + ".")) {
            return Collections.emptyList();
        }
        parentPackage = parentPackage == null ? "" : parentPackage + ".";
        ArrayList<String> classNames = new ArrayList<String>();
        for (File child : files = parent.listFiles()) {
            if (child.isDirectory()) {
                classNames.addAll(ClassesSerializableTest.findClassesInDirectory(parentPackage + child.getName(), child));
                continue;
            }
            if (!child.getName().endsWith(".class")) continue;
            classNames.add(parentPackage.replace(File.separatorChar, '.') + child.getName().replaceAll("\\.class", ""));
        }
        return classNames;
    }
}

