/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.event;

import com.vaadin.event.ShortcutAction;
import com.vaadin.shared.util.SharedUtil;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ShortcutActionTest {
    private static final String[] KEYS = "a b c d e f g h i j k l m n o p q r s t u v w x y z".split("\\s+");

    @Test
    public void testHashCodeUniqueness() {
        HashSet<ShortcutAction> set = new HashSet<ShortcutAction>();
        for (String modifier : new String[]{"^", "&", "_", "&^", "&_", "_^", "&^_"}) {
            for (String key : KEYS) {
                ShortcutAction action = new ShortcutAction(modifier + key);
                for (ShortcutAction other : set) {
                    Assert.assertFalse((boolean)ShortcutActionTest.equals(action, other));
                }
                set.add(action);
            }
        }
    }

    @Test
    public void testModifierOrderIrrelevant() {
        for (String key : KEYS) {
            ShortcutAction action2;
            for (String modifier : new String[]{"&^", "&_", "_^"}) {
                ShortcutAction action1 = new ShortcutAction(modifier + key);
                action2 = new ShortcutAction(modifier.substring(1) + modifier.substring(0, 1) + key);
                Assert.assertTrue((String)(modifier + key), (boolean)ShortcutActionTest.equals(action1, action2));
            }
            ShortcutAction action1 = new ShortcutAction("&^_" + key);
            for (String modifier : new String[]{"&_^", "^&_", "^_&", "_^&", "_&^"}) {
                action2 = new ShortcutAction(modifier + key);
                Assert.assertTrue((String)(modifier + key), (boolean)ShortcutActionTest.equals(action1, action2));
            }
        }
    }

    @Test
    public void testSameKeycodeDifferentCaptions() {
        ShortcutAction act1 = new ShortcutAction("E&xit");
        ShortcutAction act2 = new ShortcutAction("Lu&xtorpeda - Autystyczny");
        Assert.assertFalse((boolean)ShortcutActionTest.equals(act1, act2));
    }

    public static final boolean equals(ShortcutAction act, ShortcutAction other) {
        if (SharedUtil.equals((Object)other.getCaption(), (Object)act.getCaption()) && SharedUtil.equals((Object)other.getIcon(), (Object)act.getIcon()) && act.getKeyCode() == other.getKeyCode() && act.getModifiers().length == other.getModifiers().length) {
            HashSet<Integer> thisSet = new HashSet<Integer>(act.getModifiers().length);
            for (int mod : act.getModifiers()) {
                thisSet.add(mod);
            }
            for (int mod : other.getModifiers()) {
                thisSet.remove(mod);
            }
            return thisSet.isEmpty();
        }
        return false;
    }
}

