/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.event;

import com.vaadin.event.Action;
import com.vaadin.shared.ui.ContentMode;
import org.junit.Assert;
import org.junit.Test;

public class ActionTest {
    @Test
    public void testTextInActionCaption() {
        Action action = new Action("Hello, world!");
        junit.framework.Assert.assertEquals((String)"Hello, world!", (String)action.getCaption());
        action = new Action("<script src=\"malicious.js\">Test string</script>");
        junit.framework.Assert.assertEquals((String)"", (String)action.getCaption());
        action = new Action("<h1>Hello World</h1>");
        junit.framework.Assert.assertEquals((String)"Hello World", (String)action.getCaption());
    }

    @Test
    public void testPreformattedTextInActionCaption() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new Action("Hello, world!", ContentMode.PREFORMATTED));
    }

    @Test
    public void testHTMLInActionCaption() {
        Action action = new Action("Hello, world!", ContentMode.HTML);
        junit.framework.Assert.assertEquals((String)"Hello, world!", (String)action.getCaption());
        action = new Action("<script src=\"malicious.js\">Test string</script>", ContentMode.HTML);
        junit.framework.Assert.assertEquals((String)"<script src=\"malicious.js\">Test string</script>", (String)action.getCaption());
        action = new Action("<h1>Hello World</h1>", ContentMode.HTML);
        junit.framework.Assert.assertEquals((String)"<h1>Hello World</h1>", (String)action.getCaption());
        action.setCaption("<b>I want this caption in bold</b>");
        junit.framework.Assert.assertEquals((String)"I want this caption in bold", (String)action.getCaption());
        action.setCaption("<b>I really want this caption in bold</b>", ContentMode.HTML);
        junit.framework.Assert.assertEquals((String)"<b>I really want this caption in bold</b>", (String)action.getCaption());
    }
}

