/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.AbstractEmbedded;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedsTest {
    public static final boolean equals(ExternalResource obj, ExternalResource other) {
        return SharedUtil.equals((Object)obj.getURL(), (Object)other.getURL()) && SharedUtil.equals((Object)obj.getMIMEType(), (Object)other.getMIMEType());
    }

    @Test
    public void testAbstractEmbeddedsToFromDesign() throws Exception {
        for (AbstractEmbedded ae : new AbstractEmbedded[]{new Image(), new BrowserFrame()}) {
            ae.setSource((Resource)new ExternalResource("http://www.example.org"));
            ae.setAlternateText("some alternate text");
            ae.setCaption("some <b>caption</b>");
            ae.setCaptionAsHtml(true);
            ae.setDescription("some description");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Design.write((Component)ae, (OutputStream)bos);
            AbstractEmbedded result = (AbstractEmbedded)Design.read((InputStream)new ByteArrayInputStream(bos.toByteArray()));
            Assert.assertTrue((boolean)EmbeddedsTest.equals((ExternalResource)ae.getSource(), (ExternalResource)result.getSource()));
            Assert.assertEquals((Object)ae.getAlternateText(), (Object)result.getAlternateText());
            Assert.assertEquals((Object)ae.getCaption(), (Object)result.getCaption());
            Assert.assertEquals((Object)ae.isCaptionAsHtml(), (Object)result.isCaptionAsHtml());
            Assert.assertEquals((Object)ae.getDescription(), (Object)result.getDescription());
        }
    }
}

