/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.event.ShortcutAction;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.FontIcon;
import com.vaadin.server.GenericFontIcon;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.util.SharedUtil;
import com.vaadin.ui.declarative.DesignFormatter;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DesignFormatterTest {
    private DesignFormatter formatter;

    @Before
    public void setUp() {
        this.formatter = new DesignFormatter();
    }

    @Test
    public void testSupportedClasses() {
        for (Class type : new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, String.class, ShortcutAction.class, Date.class, FileResource.class, ExternalResource.class, ThemeResource.class, Resource.class, TimeZone.class}) {
            Assert.assertTrue((String)("not supported " + type.getSimpleName()), (boolean)this.formatter.canConvert(type));
        }
    }

    @Test
    public void testBoolean() {
        Assert.assertEquals((Object)"", (Object)this.formatter.format((Object)true));
        Assert.assertEquals((Object)"false", (Object)this.formatter.format((Object)false));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("true", Boolean.TYPE)));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("foobar", Boolean.TYPE)));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("", Boolean.TYPE)));
        Assert.assertFalse((boolean)((Boolean)this.formatter.parse("false", Boolean.TYPE)));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("true", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("foobar", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.formatter.parse("", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.formatter.parse("false", Boolean.class)));
    }

    @Test
    public void testIntegral() {
        byte b = 123;
        Assert.assertEquals((Object)"123", (Object)this.formatter.format((Object)b));
        Assert.assertEquals((long)b, (long)((Byte)this.formatter.parse("123", Byte.TYPE)).byteValue());
        Assert.assertEquals((Object)b, (Object)this.formatter.parse("123", Byte.class));
        b = -123;
        Assert.assertEquals((Object)"-123", (Object)this.formatter.format((Object)b));
        Assert.assertEquals((long)b, (long)((Byte)this.formatter.parse("-123", Byte.TYPE)).byteValue());
        Assert.assertEquals((Object)b, (Object)this.formatter.parse("-123", Byte.class));
        short s = 12345;
        Assert.assertEquals((Object)"12345", (Object)this.formatter.format((Object)s));
        Assert.assertEquals((long)s, (long)((Short)this.formatter.parse("12345", Short.TYPE)).shortValue());
        Assert.assertEquals((Object)s, (Object)this.formatter.parse("12345", Short.class));
        s = -12345;
        Assert.assertEquals((Object)"-12345", (Object)this.formatter.format((Object)s));
        Assert.assertEquals((long)s, (long)((Short)this.formatter.parse("-12345", Short.TYPE)).shortValue());
        Assert.assertEquals((Object)s, (Object)this.formatter.parse("-12345", Short.class));
        int i = 123456789;
        Assert.assertEquals((Object)"123456789", (Object)this.formatter.format((Object)i));
        Assert.assertEquals((long)i, (long)((Integer)this.formatter.parse("123456789", Integer.TYPE)).intValue());
        Assert.assertEquals((Object)i, (Object)this.formatter.parse("123456789", Integer.class));
        i = -123456789;
        Assert.assertEquals((Object)"-123456789", (Object)this.formatter.format((Object)i));
        Assert.assertEquals((long)i, (long)((Integer)this.formatter.parse("-123456789", Integer.TYPE)).intValue());
        Assert.assertEquals((Object)i, (Object)this.formatter.parse("-123456789", Integer.class));
        long l = 123456789123456789L;
        Assert.assertEquals((Object)"123456789123456789", (Object)this.formatter.format((Object)l));
        Assert.assertEquals((long)l, (long)((Long)this.formatter.parse("123456789123456789", Long.TYPE)));
        Assert.assertEquals((Object)l, (Object)this.formatter.parse("123456789123456789", Long.class));
        l = -123456789123456789L;
        Assert.assertEquals((Object)"-123456789123456789", (Object)this.formatter.format((Object)l));
        Assert.assertEquals((long)l, (long)((Long)this.formatter.parse("-123456789123456789", Long.TYPE)));
        Assert.assertEquals((Object)l, (Object)this.formatter.parse("-123456789123456789", Long.class));
    }

    @Test
    public void testFloatingPoint() {
        float f = 123.4567f;
        Assert.assertEquals((Object)"123.457", (Object)this.formatter.format((Object)Float.valueOf(f)));
        float f1 = ((Float)this.formatter.parse("123.4567", Float.TYPE)).floatValue();
        Assert.assertEquals((double)f, (double)f1, (double)1.0E-4);
        Float f2 = (Float)this.formatter.parse("123.4567", Float.class);
        Assert.assertEquals((double)f, (double)f2.floatValue(), (double)1.0E-4);
        double d = 1.2345678912345679E8;
        Assert.assertEquals((Object)"123456789.123", (Object)this.formatter.format((Object)d));
        Assert.assertEquals((double)d, (double)((Double)this.formatter.parse("123456789.123456789", Double.TYPE)), (double)1.0E-9);
        Assert.assertEquals((double)d, (double)((Double)this.formatter.parse("123456789.123456789", Double.class)), (double)1.0E-9);
    }

    @Test
    public void testBigDecimal() {
        BigDecimal bd = new BigDecimal("123456789123456789.123456789123456789");
        Assert.assertEquals((Object)"123456789123456789.123", (Object)this.formatter.format((Object)bd));
        Assert.assertEquals((Object)bd, (Object)this.formatter.parse("123456789123456789.123456789123456789", BigDecimal.class));
    }

    @Test
    public void testChar() {
        int c = 43981;
        Assert.assertEquals((Object)"\uabcd", (Object)this.formatter.format((Object)Character.valueOf((char)c)));
        Assert.assertEquals((long)c, (long)((Character)this.formatter.parse("\uabcd", Character.TYPE)).charValue());
        Assert.assertEquals((Object)Character.valueOf((char)c), (Object)this.formatter.parse("\uabcd", Character.class));
        c = 121;
        Assert.assertEquals((long)c, (long)((Character)this.formatter.parse("yes", Character.TYPE)).charValue());
    }

    @Test
    public void testString() {
        for (String s : new String[]{"", "foobar", "\uabcd", "\u9a6f\u9e7f"}) {
            Assert.assertEquals((Object)s, (Object)this.formatter.format((Object)s));
            Assert.assertEquals((Object)s, (Object)this.formatter.parse(s, String.class));
        }
    }

    @Test
    public void testDate() throws Exception {
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-02-17");
        String formatted = this.formatter.format((Object)date);
        Date result = (Date)this.formatter.parse(formatted, Date.class);
        String timeZone = new SimpleDateFormat("Z").format(date);
        Assert.assertEquals((Object)("2012-02-17 00:00:00" + timeZone), (Object)formatted);
        Assert.assertEquals((Object)date, (Object)result);
        result = (Date)this.formatter.parse("2012-02-17", Date.class);
        Assert.assertEquals((Object)date, (Object)result);
    }

    @Test
    public void testShortcutActions() {
        ShortcutAction action = new ShortcutAction("&^d");
        String formatted = this.formatter.format((Object)action);
        Assert.assertEquals((Object)"ctrl-alt-d d", (Object)formatted);
        ShortcutAction result = (ShortcutAction)this.formatter.parse(formatted, ShortcutAction.class);
        Assert.assertTrue((boolean)DesignFormatterTest.equals(action, result));
    }

    @Test
    public void testShortcutActionNoCaption() {
        ShortcutAction action = new ShortcutAction(null, 68, new int[]{18, 17});
        String formatted = this.formatter.format((Object)action);
        Assert.assertEquals((Object)"ctrl-alt-d", (Object)formatted);
        ShortcutAction result = (ShortcutAction)this.formatter.parse(formatted, ShortcutAction.class);
        Assert.assertTrue((boolean)DesignFormatterTest.equals(action, result));
    }

    @Test
    public void testInvalidShortcutAction() {
        this.assertInvalidShortcut("-");
        this.assertInvalidShortcut("foo");
        this.assertInvalidShortcut("atl-ctrl");
        this.assertInvalidShortcut("-a");
    }

    protected void assertInvalidShortcut(String shortcut) {
        try {
            this.formatter.parse(shortcut, ShortcutAction.class);
            Assert.fail((String)("Invalid shortcut '" + shortcut + "' should throw"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeZone() {
        TimeZone zone = TimeZone.getTimeZone("GMT+2");
        String formatted = this.formatter.format((Object)zone);
        Assert.assertEquals((Object)"GMT+02:00", (Object)formatted);
        TimeZone result = (TimeZone)this.formatter.parse(formatted, TimeZone.class);
        Assert.assertEquals((Object)zone, (Object)result);
        result = (TimeZone)this.formatter.parse("GMT+2", TimeZone.class);
        Assert.assertEquals((Object)zone, (Object)result);
    }

    @Test
    public void testExternalResource() {
        String url = "://example.com/my%20icon.png?a=b";
        for (String scheme : new String[]{"http", "https", "ftp", "ftps"}) {
            Resource resource = (Resource)this.formatter.parse(scheme + url, Resource.class);
            Assert.assertTrue((String)(scheme + " url should be parsed as ExternalResource"), (boolean)(resource instanceof ExternalResource));
            Assert.assertEquals((String)"parsed ExternalResource", (Object)(scheme + url), (Object)((ExternalResource)resource).getURL());
            String formatted = this.formatter.format((Object)new ExternalResource(scheme + url));
            Assert.assertEquals((String)"formatted ExternalResource", (Object)(scheme + url), (Object)formatted);
        }
    }

    @Test
    public void testResourceFormat() {
        String httpUrl = "http://example.com/icon.png";
        String httpsUrl = "https://example.com/icon.png";
        String themePath = "icons/icon.png";
        String fontAwesomeUrl = "fonticon://FontAwesome/f0f9";
        String someOtherFontUrl = "fonticon://SomeOther/F0F9";
        String fileSystemPath = "c:/app/resources/icon.png";
        Assert.assertEquals((Object)httpUrl, (Object)this.formatter.format((Object)new ExternalResource(httpUrl)));
        Assert.assertEquals((Object)httpsUrl, (Object)this.formatter.format((Object)new ExternalResource(httpsUrl)));
        Assert.assertEquals((Object)("theme://" + themePath), (Object)this.formatter.format((Object)new ThemeResource(themePath)));
        Assert.assertEquals((Object)fontAwesomeUrl, (Object)this.formatter.format((Object)FontAwesome.AMBULANCE));
        Assert.assertEquals((Object)someOtherFontUrl.toLowerCase(Locale.ROOT), (Object)this.formatter.format((Object)new GenericFontIcon("SomeOther", 61689)).toLowerCase(Locale.ROOT));
        Assert.assertEquals((Object)fileSystemPath, (Object)this.formatter.format((Object)new FileResource(new File(fileSystemPath))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResourceParseException() {
        String someRandomResourceUrl = "random://url";
        this.formatter.parse(someRandomResourceUrl, Resource.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResourceFormatException() {
        this.formatter.format((Object)new Resource(){

            public String getMIMEType() {
                return null;
            }
        });
    }

    @Test
    public void testResourceParse() {
        String httpUrl = "http://example.com/icon.png";
        String httpsUrl = "https://example.com/icon.png";
        String themePath = "icons/icon.png";
        String fontAwesomeUrl = "fonticon://FontAwesome/f0f9";
        String someOtherFont = "fonticon://SomeOther/F0F9";
        String fontAwesomeUrlOld = "font://AMBULANCE";
        String fileSystemPath = "c:\\app\\resources\\icon.png";
        Assert.assertEquals((Object)new ExternalResource(httpUrl).getURL(), (Object)((ExternalResource)this.formatter.parse(httpUrl, ExternalResource.class)).getURL());
        Assert.assertEquals((Object)new ExternalResource(httpsUrl).getURL(), (Object)((ExternalResource)this.formatter.parse(httpsUrl, ExternalResource.class)).getURL());
        Assert.assertEquals((Object)new ThemeResource(themePath), (Object)this.formatter.parse("theme://" + themePath, ThemeResource.class));
        Assert.assertEquals((Object)FontAwesome.AMBULANCE, (Object)this.formatter.parse(fontAwesomeUrlOld, FontAwesome.class));
        Assert.assertEquals((Object)FontAwesome.AMBULANCE, (Object)this.formatter.parse(fontAwesomeUrl, FontAwesome.class));
        Assert.assertEquals((Object)new GenericFontIcon("SomeOther", 61689), (Object)this.formatter.parse(someOtherFont, FontIcon.class));
        Assert.assertEquals((Object)new FileResource(new File(fileSystemPath)).getSourceFile(), (Object)((FileResource)this.formatter.parse(fileSystemPath, FileResource.class)).getSourceFile());
    }

    public static final boolean equals(ShortcutAction act, ShortcutAction other) {
        if (SharedUtil.equals((Object)other.getCaption(), (Object)act.getCaption()) && SharedUtil.equals((Object)other.getIcon(), (Object)act.getIcon()) && act.getKeyCode() == other.getKeyCode() && act.getModifiers().length == other.getModifiers().length) {
            HashSet<Integer> thisSet = new HashSet<Integer>(act.getModifiers().length);
            for (int mod : act.getModifiers()) {
                thisSet.add(mod);
            }
            for (int mod : other.getModifiers()) {
                thisSet.remove(mod);
            }
            return thisSet.isEmpty();
        }
        return false;
    }
}

