/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.shared.Connector;
import com.vaadin.tests.design.DeclarativeTestBaseBase;
import com.vaadin.ui.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;

public abstract class DeclarativeTestBase<T extends Component>
extends DeclarativeTestBaseBase<T> {
    private static final boolean debug = false;
    private final Map<Class<?>, DeclarativeTestBaseBase.EqualsAsserter<?>> comparators = new HashMap();
    private static final DeclarativeTestBaseBase.EqualsAsserter standardEqualsComparator = Assert::assertEquals;

    protected boolean acceptProperty(Class<?> clazz, Method readMethod, Method writeMethod) {
        if (readMethod == null || writeMethod == null) {
            return false;
        }
        readMethod.setAccessible(true);
        writeMethod.setAccessible(true);
        if (Connector.class.isAssignableFrom(clazz) && readMethod.getName().equals("getParent")) {
            return false;
        }
        try {
            clazz.getDeclaredMethod(readMethod.getName(), new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected DeclarativeTestBaseBase.EqualsAsserter getComparator(Class c) {
        DeclarativeTestBaseBase.EqualsAsserter<?> comp = this.comparators.get(c);
        if (comp == null) {
            if (c.isEnum()) {
                return standardEqualsComparator;
            }
            return new IntrospectorEqualsAsserter(c);
        }
        return comp;
    }

    public class IntrospectorEqualsAsserter<C>
    implements DeclarativeTestBaseBase.EqualsAsserter<C> {
        private final Class<C> clazz;

        public IntrospectorEqualsAsserter(Class<C> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void assertObjectEquals(C object1, C object2) {
            try {
                BeanInfo bi = Introspector.getBeanInfo(this.clazz);
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Method writeMethod;
                    Method readMethod = pd.getReadMethod();
                    if (!DeclarativeTestBase.this.acceptProperty(this.clazz, readMethod, writeMethod = pd.getWriteMethod())) continue;
                    Object property1 = readMethod.invoke(object1, new Object[0]);
                    Object property2 = readMethod.invoke(object2, new Object[0]);
                    DeclarativeTestBase.this.assertEqualsCustom(pd.getDisplayName(), property1, property2);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

