/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ComponentFactoryTest {
    private static final Design.ComponentFactory defaultFactory = Design.getComponentFactory();
    private static final ThreadLocal<Design.ComponentFactory> currentComponentFactory = new ThreadLocal();

    @Test(expected=IllegalArgumentException.class)
    public void testSetNullComponentFactory() {
        Design.setComponentFactory(null);
    }

    @Test
    public void testComponentFactoryLogging() {
        ArrayList messages = new ArrayList();
        currentComponentFactory.set((Design.ComponentFactory & Serializable)(fullyQualifiedClassName, context) -> {
            messages.add("Requested class " + fullyQualifiedClassName);
            return defaultFactory.createComponent(fullyQualifiedClassName, context);
        });
        Design.read((InputStream)new ByteArrayInputStream("<vaadin-label />".getBytes()));
        Assert.assertEquals((String)"There should be one message logged", (long)1L, (long)messages.size());
        Assert.assertEquals((Object)("Requested class " + Label.class.getCanonicalName()), messages.get(0));
    }

    @Test(expected=DesignException.class)
    public void testComponentFactoryReturningNull() {
        currentComponentFactory.set((Design.ComponentFactory & Serializable)(fullyQualifiedClassName, context) -> null);
        Design.read((InputStream)new ByteArrayInputStream("<vaadin-label />".getBytes()));
    }

    @Test(expected=DesignException.class)
    public void testComponentFactoryThrowingStuff() {
        currentComponentFactory.set((Design.ComponentFactory & Serializable)(fullyQualifiedClassName, context) -> defaultFactory.createComponent("foobar." + fullyQualifiedClassName, context));
        Design.read((InputStream)new ByteArrayInputStream("<vaadin-label />".getBytes()));
    }

    @Test
    public void testGetDefaultInstanceUsesComponentFactory() {
        ArrayList classes = new ArrayList();
        currentComponentFactory.set((Design.ComponentFactory & Serializable)(fullyQualifiedClassName, context) -> {
            classes.add(fullyQualifiedClassName);
            return defaultFactory.createComponent(fullyQualifiedClassName, context);
        });
        DesignContext designContext = new DesignContext();
        designContext.getDefaultInstance((Component)new DefaultInstanceTestComponent());
        Assert.assertEquals((String)"There should be one class requests", (long)1L, (long)classes.size());
        Assert.assertEquals((String)"First class should be DefaultInstanceTestComponent", (Object)DefaultInstanceTestComponent.class.getName(), classes.get(0));
    }

    @After
    public void cleanup() {
        currentComponentFactory.remove();
    }

    static {
        Design.setComponentFactory((Design.ComponentFactory & Serializable)(fullyQualifiedClassName, context) -> {
            Design.ComponentFactory componentFactory = currentComponentFactory.get();
            if (componentFactory == null) {
                componentFactory = defaultFactory;
            }
            return componentFactory.createComponent(fullyQualifiedClassName, context);
        });
    }

    public static class DefaultInstanceTestComponent
    extends AbstractComponent {
    }
}

